/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.auth.api;

import com.alibaba.csp.ahas.shaded.org.apache.commons.codec.binary.Base64;
import com.alibaba.csp.ahas.shaded.org.apache.commons.codec.binary.Hex;
import com.alibaba.csp.ahas.shaded.org.apache.commons.codec.digest.DigestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Properties;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AuthUtil {
    public static final String CHARSET_NAME = "UTF-8";
    public static final String AHAS_CERT_ENV = "ahas.cert";
    public static final String ACCESS_KEY = "AK";
    public static final String SECRET_KEY = "SK";
    private static final String CR_LF_UNIX = "\n";
    private static final String CR_LF_WIN = "\r\n";
    private static final String DEFAULT_CREDENTIAL_PATH = System.getProperty("user.home", "/home") + "/.ahas.cert";
    private static String accessKey;
    private static String secretKey;

    public static String generateAccessKey() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String generateSecretKey() {
        return UUID.randomUUID().toString().replaceAll("-", "");
    }

    public static String getAccessKey() {
        if (accessKey != null) {
            return accessKey;
        }
        AuthUtil.readCredentialKey();
        return accessKey;
    }

    public static String getSecretKey() {
        if (secretKey != null) {
            return secretKey;
        }
        AuthUtil.readCredentialKey();
        return secretKey;
    }

    private static void readCredentialKey() {
        File credentialFile = AuthUtil.getCredentialFile();
        Properties properties = new Properties();
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(credentialFile);
            properties.load(inStream);
            accessKey = properties.getProperty(ACCESS_KEY);
            secretKey = properties.getProperty(SECRET_KEY);
        }
        catch (IOException e) {
            throw new RuntimeException("Load credential file exception, file: " + credentialFile.getAbsolutePath());
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static File getCredentialFile() {
        String certFile = System.getProperty(AHAS_CERT_ENV, DEFAULT_CREDENTIAL_PATH);
        File file = new File(certFile);
        if (!file.exists()) {
            throw new RuntimeException("Cannot find ahas credential file, please specify -Dahas.cert=/path/file jvm opts.");
        }
        return file;
    }

    public static void reloadCredentialFile() {
        AuthUtil.readCredentialKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recordKeyToFile(String accessKey, String secretKey) throws Exception {
        boolean newFile;
        if (AuthUtil.isEmpty(accessKey) || AuthUtil.isEmpty(secretKey)) {
            throw new Exception("accessKey or secretKey is empty");
        }
        File credentialFile = null;
        try {
            credentialFile = AuthUtil.getCredentialFile();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (credentialFile == null) {
            credentialFile = new File(System.getProperty(AHAS_CERT_ENV, DEFAULT_CREDENTIAL_PATH));
        }
        if (!credentialFile.exists() && !(newFile = credentialFile.createNewFile())) {
            throw new Exception("Create file failed. file: " + credentialFile.getAbsolutePath());
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(credentialFile, false);
            String key = "AK=" + accessKey;
            String separator = System.getProperty("line.separator");
            fileWriter.write(key + separator);
            key = "SK=" + secretKey;
            fileWriter.write(key + separator);
            fileWriter.flush();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
        AuthUtil.reloadCredentialFile();
    }

    public static boolean auth(String sign, String secretKey, String signData) {
        try {
            String expectSign = AuthUtil.sign(secretKey, signData);
            return expectSign.equals(sign);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String sign(String sk, String signData) throws Exception {
        if (AuthUtil.isEmpty(sk) || AuthUtil.isEmpty(signData)) {
            throw new IllegalArgumentException("the parameter is empty");
        }
        String sha256 = AuthUtil.sha256(signData + sk);
        return AuthUtil.base64(sha256.getBytes(CHARSET_NAME), false);
    }

    public static String encrypt(String sk, String message) throws Exception {
        if (message == null || message.isEmpty()) {
            return message;
        }
        SecretKeySpec keySpec = new SecretKeySpec(DigestUtils.md5(sk), "AES");
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
        IvParameterSpec iv = new IvParameterSpec(DigestUtils.md5(sk));
        cipher.init(1, (Key)keySpec, iv);
        byte[] bytes = message.getBytes("utf-8");
        int i128 = 128;
        byte[] result = new byte[(bytes.length + 128 - 1) / 128 * 128];
        for (int i = 0; i < bytes.length; i += 128) {
            int len = 128;
            if (i + len > bytes.length) {
                len = bytes.length - i;
            }
            byte[] en = AuthUtil.encrypt128(bytes, i, len, cipher);
            System.arraycopy(en, 0, result, i, 128);
        }
        return new String(Base64.encodeBase64(result));
    }

    private static byte[] encrypt128(byte[] bytes, int offset, int len, Cipher cipher) throws Exception {
        int i128 = 128;
        byte[] result = len == 128 ? cipher.doFinal(bytes, offset, 128) : cipher.doFinal(Arrays.copyOfRange(bytes, offset, offset + 128));
        return result;
    }

    public static String decrypt(String sk, String message) throws Exception {
        if (message == null || message.isEmpty()) {
            return message;
        }
        SecretKeySpec keySpec = new SecretKeySpec(DigestUtils.md5(sk), "AES");
        Cipher cipher = Cipher.getInstance("AES/CFB/NoPadding");
        IvParameterSpec iv = new IvParameterSpec(DigestUtils.md5(sk));
        cipher.init(2, (Key)keySpec, iv);
        byte[] bytes = Base64.decodeBase64(message.getBytes());
        int i128 = 128;
        if (bytes.length % 128 != 0) {
            throw new RuntimeException("illegal message size, must mod 128");
        }
        byte[] result = new byte[bytes.length];
        for (int i = 0; i < bytes.length; i += 128) {
            byte[] decrypt = cipher.doFinal(bytes, i, 128);
            System.arraycopy(decrypt, 0, result, i, 128);
        }
        return new String(result, "utf-8").trim();
    }

    public static String sha256(String value) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] sha256 = digest.digest(value.getBytes(CHARSET_NAME));
        return new String(Hex.encodeHex(sha256));
    }

    public static String base64(byte[] bytes, boolean isChunked) {
        String result;
        block3: {
            String endChars;
            block2: {
                byte[] byte64 = Base64.encodeBase64(bytes, isChunked);
                result = new String(byte64);
                endChars = CR_LF_UNIX;
                if (result.endsWith(CR_LF_UNIX)) break block2;
                endChars = CR_LF_WIN;
                if (!result.endsWith(CR_LF_WIN)) break block3;
            }
            result = result.substring(0, result.length() - endChars.length());
        }
        return result;
    }

    public static String md5(File file) throws IOException {
        return DigestUtils.md5Hex(AuthUtil.readFileToByteArray(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFileToByteArray(File file) throws IOException {
        byte[] bytes;
        FileInputStream in = null;
        try {
            in = AuthUtil.openInputStream(file);
            bytes = AuthUtil.toByteArray(in, file.length());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return bytes;
    }

    private static byte[] toByteArray(InputStream input, long size) throws IOException {
        int offset;
        int readed;
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Exceeding the maximum limit of integer, size: " + size);
        }
        int length = (int)size;
        if (length < 0) {
            throw new IllegalArgumentException("Size cannot be negative, size: " + length);
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] data = new byte[length];
        for (offset = 0; offset < length && (readed = input.read(data, offset, length - offset)) != -1; offset += readed) {
        }
        if (offset != length) {
            throw new IOException("Readed offset not equal the file length. current: " + offset + ", excepted: " + length);
        }
        return data;
    }

    private static FileInputStream openInputStream(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canRead()) {
                throw new IOException("File '" + file + "' cannot be read");
            }
            return new FileInputStream(file);
        }
        throw new FileNotFoundException("File '" + file + "' does not exist");
    }

    private static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }
}

