/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.client.ClientConnection;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessage;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.util.ConnectionUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.listener.IClientConnectionListener;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.listener.client.ClientConnectionListenerFactory;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelDuplexHandler;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelFutureListener;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelOption;
import com.alibaba.csp.ahas.shaded.io.netty.channel.ChannelPromise;
import com.alibaba.csp.ahas.shaded.io.netty.handler.timeout.IdleStateEvent;
import java.net.SocketAddress;
import java.util.List;

public class NettyClientHandler
extends ChannelDuplexHandler {
    private List<IClientConnectionListener> listeners = ClientConnectionListenerFactory.getInstance().getListeners();
    private Integer connectionId;

    public NettyClientHandler(Integer connectionId) {
        this.connectionId = connectionId;
    }

    @Override
    public void connect(ChannelHandlerContext ctx, final SocketAddress remoteAddress, final SocketAddress localAddress, ChannelPromise future) throws Exception {
        future.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientHandler.this.callConnectFailListeners(localAddress, remoteAddress, future.channel().config().getOption(ChannelOption.CONNECT_TIMEOUT_MILLIS), future.cause());
                }
            }
        });
        super.connect(ctx, remoteAddress, localAddress, future);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (ConnectionUtil.connectionOfChannel(ctx.channel()) == null) {
            ClientConnection connection = new ClientConnection(ctx.channel());
            connection.setConnectionId(this.connectionId);
            ConnectionUtil.bindConnection(ctx.channel(), connection);
        }
        this.callConnectSuccessListeners((ClientConnection)ConnectionUtil.connectionOfChannel(ctx.channel()));
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.callConnectionCloseListeners((ClientConnection)ConnectionUtil.connectionOfChannel(ctx.channel()));
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.callConnectionExceptionListeners((ClientConnection)ConnectionUtil.connectionOfChannel(ctx.channel()), cause);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            this.callConnectionIdleListeners((ClientConnection)ConnectionUtil.connectionOfChannel(ctx.channel()));
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object writeRequest, ChannelPromise promise) throws Exception {
        final ClientConnection connection = (ClientConnection)ConnectionUtil.connectionOfChannel(ctx.channel());
        final AgwMessage message = (AgwMessage)writeRequest;
        this.callConnectionWriteListeners(connection, message);
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    NettyClientHandler.this.callConnectionWriteSuccessListeners(connection, message);
                } else {
                    NettyClientHandler.this.callConnectionWriteFailedListeners(connection, message, future.cause());
                }
            }
        });
        ctx.write(writeRequest, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object message) throws Exception {
        this.callConnectionReadListeners((ClientConnection)ConnectionUtil.connectionOfChannel(ctx.channel()), (AgwMessage)message);
    }

    private void callConnectFailListeners(SocketAddress localAddress, SocketAddress remoteAddress, int timeout, Throwable cause) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.connectFail(localAddress, remoteAddress, timeout, cause);
            }
            catch (Exception ex) {
                AgwLogger.warn("run listener wrong", ex);
            }
        }
    }

    private void callConnectSuccessListeners(ClientConnection connection) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.connectSuccess(connection);
            }
            catch (Exception ex) {
                AgwLogger.warn("run listener wrong", ex);
            }
        }
    }

    private void callConnectionCloseListeners(ClientConnection connection) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.close(connection);
            }
            catch (Exception ex) {
                AgwLogger.warn("run listener wrong", ex);
            }
        }
    }

    private void callConnectionExceptionListeners(ClientConnection connection, Throwable cause) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.exceptionCaught(connection, cause);
            }
            catch (Exception ex) {
                AgwLogger.warn("run listener wrong", ex);
            }
        }
    }

    private void callConnectionIdleListeners(ClientConnection connection) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.idle(connection);
            }
            catch (Exception ex) {
                AgwLogger.warn("run listener wrong", ex);
            }
        }
    }

    private void callConnectionWriteListeners(ClientConnection connection, AgwMessage message) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.write(connection, message);
            }
            catch (Exception ex) {
                AgwLogger.warn(String.format("run write listener wrong, connection:%d, reqId:%d, outerReqId:%s", connection.info(), message.getHeader().getReqId(), message.getHeader().getOuterReqId()), ex);
            }
        }
    }

    private void callConnectionWriteSuccessListeners(ClientConnection connection, AgwMessage message) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.writeSuccess(connection, message);
            }
            catch (Exception ex) {
                AgwLogger.warn(String.format("run write success listener wrong, connection:%d, reqId:%d, outerReqId:%s", connection.info(), message.getHeader().getReqId(), message.getHeader().getOuterReqId()), ex);
            }
        }
    }

    private void callConnectionWriteFailedListeners(ClientConnection connection, AgwMessage message, Throwable cause) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.writeFail(connection, message, cause);
            }
            catch (Exception ex) {
                AgwLogger.warn(String.format("run write fail listener wrong, connection:%d, reqId:%d, outerReqId:%s", connection.info(), message.getHeader().getReqId(), message.getHeader().getOuterReqId()), ex);
            }
        }
    }

    private void callConnectionReadListeners(ClientConnection connection, AgwMessage message) {
        for (IClientConnectionListener listener : this.listeners) {
            try {
                listener.read(connection, message);
            }
            catch (Exception ex) {
                AgwLogger.warn(String.format("run read listener wrong, connection:%d, reqId:%d, outerReqId:%s", connection.info(), message.getHeader().getReqId(), message.getHeader().getOuterReqId()), ex);
            }
        }
    }
}

