/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.processor.client;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.bootstrap.HandlerCenter;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.client.api.handler.AgwHandler;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.connection.Connection;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.io.protocol.AgwMessage;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.log.AgwPerfLogger;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.processor.IProcessor;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.upstream.RpcResultCodeEnum;
import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.ThreadPoolManager;

public class BizRequestClientProcessor
implements IProcessor {
    private static BizRequestClientProcessor instance = new BizRequestClientProcessor();

    private BizRequestClientProcessor() {
    }

    public static BizRequestClientProcessor getInstance() {
        return instance;
    }

    @Override
    public void process(final Connection connection, final AgwMessage request) {
        ThreadPoolManager.getInstance().getClientThreadPool().execute(new Runnable(){

            @Override
            public void run() {
                request.mark("gateway_call_client");
                AgwMessage response = BizRequestClientProcessor.this.callHandler(request);
                connection.writeAndFlush(response);
            }
        });
    }

    private AgwMessage callHandler(AgwMessage request) {
        String handlerName = request.getHeader().getHandlerName();
        AgwHandler handler = HandlerCenter.getHandler(handlerName);
        if (handler == null) {
            AgwLogger.warn(String.format("can not get handler by handlerName[%s], reqId:%d, outerReqId:%s", handlerName, request.getHeader().getReqId(), request.getHeader().getOuterReqId()), new Object[0]);
            request.getHeader().setRpcResultCodeEnum(RpcResultCodeEnum.RPC_CLIENT_HANDLER_NOT_FOUND);
            request.getHeader().setMessageDirection((byte)2);
            return request;
        }
        String result = null;
        try {
            request.mark("before_handle");
            result = handler.handle(request.getBody());
            request.mark("after_handle");
        }
        catch (Throwable t) {
            AgwLogger.warn(String.format("executor handler[%s] wrong, reqId:%d, outerReqId:%s", handlerName, request.getHeader().getReqId(), request.getHeader().getOuterReqId()), t);
            request.mark("handle_exception");
            AgwPerfLogger.info(request.getPerf(), new Object[0]);
            request.setBody("something wrong happen");
            request.getHeader().setRpcResultCodeEnum(RpcResultCodeEnum.RPC_CLIENT_HANDLER_EXECUTE_WRONG);
            request.getHeader().setMessageDirection((byte)2);
            return request;
        }
        if (result == null) {
            result = "";
        }
        request.setBody(result);
        request.getHeader().setRpcResultCodeEnum(RpcResultCodeEnum.RPC_OK);
        request.getHeader().setMessageDirection((byte)2);
        AgwPerfLogger.info(request.getPerf(), new Object[0]);
        return request;
    }
}

