/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread;

import com.alibaba.csp.ahas.shaded.com.taobao.csp.ahas.gw.utils.thread.NamedThreadFactory;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ThreadPoolManager {
    private static ThreadPoolManager instance = new ThreadPoolManager();
    private ThreadPoolExecutor serverPool;
    private ThreadPoolExecutor clientPool;
    private AtomicBoolean serverPoolInited = new AtomicBoolean();
    private AtomicBoolean clientPoolInited = new AtomicBoolean();

    private ThreadPoolManager() {
    }

    public static ThreadPoolManager getInstance() {
        return instance;
    }

    private void initServerThreadPool() {
        int coreSize = 100;
        int maxSize = 200;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizProcessor - DEFAULT");
        this.serverPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(800), threadFactory);
    }

    private void initClientThreadPool() {
        int coreSize = 2;
        int maxSize = 10;
        long keepAliveTime = 20L;
        NamedThreadFactory threadFactory = new NamedThreadFactory("AgwBizProcessor - DEFAULT");
        this.clientPool = new ThreadPoolExecutor(coreSize, maxSize, keepAliveTime, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(16), threadFactory);
    }

    public ThreadPoolExecutor getServerThreadPool() {
        if (this.serverPoolInited.get()) {
            return this.serverPool;
        }
        if (this.serverPoolInited.compareAndSet(false, true)) {
            this.initServerThreadPool();
            return this.serverPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.serverPool;
    }

    public ThreadPoolExecutor getClientThreadPool() {
        if (this.clientPoolInited.get()) {
            return this.clientPool;
        }
        if (this.clientPoolInited.compareAndSet(false, true)) {
            this.initClientThreadPool();
            return this.clientPool;
        }
        try {
            TimeUnit.MILLISECONDS.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.clientPool;
    }

    public String getDefaultThreadPoolName() {
        return "AgwBizProcessor - DEFAULT";
    }
}

