/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl;

import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.com.alibaba.metrics.FastCompass;
import com.alibaba.csp.ahas.shaded.com.alibaba.acm.shaded.org.codehaus.jackson.type.TypeReference;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.BatchHttpResult;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.CacheData;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ClientWorker;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.HttpSimpleClient;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.LocalConfigInfoProcessor;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.LocalEncryptedDataKeyProcessor;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.LogUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ServerHttpAgent;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.ServerListManager;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.client.impl.TenantUtil;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.common.Constants;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.common.GroupKey;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.ConfigInfo;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.ConfigInfo4Beta;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.ConfigInfoEx;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.ConfigKey;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.Page;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.domain.RestResult;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.exception.DiamondException;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.maintenance.DiamondMetric;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.IConfigFilter;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.ManagerListener;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.impl.ConfigFilterChainManager;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.impl.ConfigRequest;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.manager.impl.ConfigResponse;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.md5.MD5;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.mockserver.MockServer;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.ContentUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.JSONUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.ParamUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.diamond.utils.StringUtils;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.Logger;
import com.alibaba.csp.ahas.shaded.com.taobao.middleware.logger.support.LoggerHelper;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class DiamondEnv {
    public static final Logger log = LogUtils.logger(DiamondEnv.class);
    public static final long POST_TIMEOUT = 3000L;
    protected ServerListManager serverMgr;
    protected ServerHttpAgent agent;
    protected ClientWorker worker;
    private final AtomicReference<Map<String, CacheData>> cacheMap;
    private double PER_TASK_CONFIG_SIZE = 3000.0;
    private ConfigFilterChainManager configFilterChainManager = new ConfigFilterChainManager();

    public void addListeners(String dataId, String group, List<? extends ManagerListener> listeners) {
        group = this.null2defaultGroup(group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    @Deprecated
    public void addListeners(String tenant, String dataId, String group, List<? extends ManagerListener> listeners) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkTDG(tenant, dataId, group);
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    @Deprecated
    public void addTenantListeners(String dataId, String group, List<? extends ManagerListener> listeners) {
        group = this.null2defaultGroup(group);
        String tenant = TenantUtil.getUserTenant();
        CacheData cache = this.addCacheDataIfAbsent(dataId, group, tenant);
        for (ManagerListener managerListener : listeners) {
            cache.addListener(managerListener);
        }
    }

    public void removeListener(String dataId, String group, ManagerListener listener) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group);
            }
        }
    }

    @Deprecated
    public void removeTenantListener(String dataId, String group, ManagerListener listener) {
        String tenant;
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group), tenant = TenantUtil.getUserTenant());
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group, tenant);
            }
        }
    }

    public void removeListener(String dataId, ManagerListener listener) {
        String group = this.null2defaultGroup(null);
        String tenant = TenantUtil.getUserTenant();
        CacheData cache = this.getCache(tenant, dataId, group);
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(tenant, dataId, group);
            }
        }
    }

    @Deprecated
    public void removeListener(String tenant, String dataId, String group, ManagerListener listener) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkTDG(tenant, dataId, group);
        CacheData cache = this.getCache(dataId, group, tenant);
        if (null != cache) {
            cache.removeListener(listener);
            if (cache.getListeners().isEmpty()) {
                this.removeCache(dataId, group, tenant);
            }
        }
    }

    public List<ManagerListener> getListeners(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group = this.null2defaultGroup(group));
        if (null == cache) {
            return Collections.emptyList();
        }
        return cache.getListeners();
    }

    @Deprecated
    public List<ManagerListener> getListeners(String tenant, String dataId, String group) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkTDG(tenant, dataId, group);
        CacheData cache = this.getCache(dataId, group, tenant);
        if (null == cache) {
            return Collections.emptyList();
        }
        return cache.getListeners();
    }

    @Deprecated
    public String getTenantConfig(String dataId, String group, long timeoutMs) throws DiamondException {
        return this.getConfigInner(TenantUtil.getUserTenant(), dataId, group, timeoutMs);
    }

    public List<ConfigKey> getAllTenantConfig(long timeoutMs) throws DiamondException {
        String tenant = TenantUtil.getUserTenant();
        if (StringUtils.isBlank(tenant)) {
            log.warn("[getAllTenantConfig]", "invalid param tenant=" + tenant);
            throw new DiamondException(400, "invalid param tenant=" + tenant);
        }
        ArrayList<ConfigKey> configs = new ArrayList<ConfigKey>();
        Page<ConfigKey> configPage = this.getAllTenantConfigInner(tenant, 1, 1, timeoutMs);
        int total = configPage.getTotalCount();
        int pageSize = 200;
        int i = 0;
        while (i * pageSize < total) {
            configPage = this.getAllTenantConfigInner(tenant, i + 1, pageSize, timeoutMs);
            configs.addAll(configPage.getPageItems());
            ++i;
        }
        return configs;
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        try {
            return this.getConfigInner(TenantUtil.getUserTenant(), dataId, group, timeoutMs);
        }
        catch (DiamondException e) {
            throw new IOException(e.toString());
        }
    }

    @Deprecated
    public String getGlobalConfig(String dataId, String group, long timeoutMs) throws DiamondException {
        return this.getConfigInner(TenantUtil.getUserTenant(), dataId, group, timeoutMs);
    }

    public String getConfigTag(String dataId, String group, String tag, long timeoutMs) throws DiamondException {
        return this.getConfigTagInner(TenantUtil.getUserTenant(), dataId, group, tag, timeoutMs);
    }

    @Deprecated
    public String getConfig(String tenant, String dataId, String group, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.getConfigInner(tenant, dataId, group, timeoutMs);
    }

    @Deprecated
    public String getConfigTag(String tenant, String dataId, String group, String tag, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.getConfigTagInner(tenant, dataId, group, tag, timeoutMs);
    }

    private String getConfigInner(String tenant, String dataId, String group, long timeoutMs) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group, tenant);
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this, dataId, group, tenant);
            return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
        }
        try {
            ConfigInfo configInfo = ClientWorker.getServerConfig(this, dataId, group, tenant, false, timeoutMs);
            return this.doFilter(dataId, group, tenant, configInfo);
        }
        catch (DiamondException ioe) {
            if (403 == ioe.getErrCode()) {
                throw ioe;
            }
            log.warn("Diamond-0003", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0003", "\u73af\u5883\u95ee\u9898", "get from server error"));
            log.warn(this.getName(), "[get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, ioe.toString());
            content = LocalConfigInfoProcessor.getSnapshot(this, dataId, group, tenant);
            log.warn(this.getName(), "[get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshot(this, dataId, group, tenant);
            return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
        }
    }

    private String getServerConfigInner(String tenant, String dataId, String group, long timeoutMs) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group, tenant);
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this, dataId, group, tenant);
            return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
        }
        try {
            ConfigInfo configInfo = ClientWorker.getServerConfig(this, dataId, group, tenant, false, timeoutMs);
            return this.doFilter(dataId, group, tenant, configInfo);
        }
        catch (DiamondException ioe) {
            log.warn("Diamond-0003", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0003", "\u73af\u5883\u95ee\u9898", "get from server error"));
            log.warn(this.getName(), "[get-config] get from server error, dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, ioe.toString());
            throw ioe;
        }
    }

    private String getConfigTagInner(String tenant, String dataId, String group, String tag, long readTimeout) throws DiamondException {
        if (StringUtils.isBlank(group)) {
            group = "DEFAULT_GROUP";
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            ArrayList<String> params = new ArrayList<String>();
            params.add("dataId");
            params.add(dataId);
            params.add("group");
            params.add(group);
            if (StringUtils.isNotEmpty(tenant)) {
                params.add("tenant");
                params.add(tenant);
            }
            if (StringUtils.isNotEmpty(tag)) {
                params.add("tag");
                params.add(tag);
            }
            result = this.agent.httpGet("/config.co", null, params, "GBK", readTimeout);
        }
        catch (IOException e) {
            log.error(this.getName(), "DIAMOND-XXXX", "[sub-server] get server config exception, dataId={}, group={}, tenant={}, msg={}", dataId, group, tenant, e.toString());
            throw new DiamondException(500, e.getMessage(), e);
        }
        switch (result.code) {
            case 200: {
                return result.content;
            }
            case 404: {
                return null;
            }
            case 409: {
                log.error(this.getName(), "DIAMOND-XXXX", "[sub-server-error] get server config being modified concurrently, dataId={}, group={}, tenant={}", dataId, group, tenant);
                throw new DiamondException(409, "data being modified, dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
            }
            case 403: {
                log.error(this.getName(), "DIAMOND-XXXX", "[sub-server-error] no right, dataId={}, group={}, tenant={}", dataId, group, tenant);
                throw new DiamondException(result.code, result.content);
            }
        }
        log.error(this.getName(), "DIAMOND-XXXX", "[sub-server-error]  dataId={}, group={}, tenant={}, code={}", dataId, group, tenant, result.code);
        throw new DiamondException(result.code, "http error, code=" + result.code + ",dataId=" + dataId + ",group=" + group + ",tenant=" + tenant);
    }

    public String getConfig(String dataId, String group, int feature, long timeoutMs) throws IOException {
        group = this.null2defaultGroup(group);
        if (feature == 1) {
            return this.getConfig(dataId, group, timeoutMs);
        }
        if (feature == 3) {
            try {
                return this.getServerConfigInner(TenantUtil.getUserTenant(), dataId, group, timeoutMs);
            }
            catch (DiamondException e) {
                throw new IOException(e);
            }
        }
        if (MockServer.isTestMode()) {
            return MockServer.getConfigInfo(dataId, group, this);
        }
        String content = LocalConfigInfoProcessor.getFailover(this, dataId, group, TenantUtil.getUserTenant());
        if (content != null) {
            log.warn(this.getName(), "[get-config] get failover ok, dataId={}, group={}, tenant={}, config={}", dataId, group, TenantUtil.getUserTenant(), ContentUtils.truncateContent(content));
            String tenant = TenantUtil.getUserTenant();
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeyFailover(this, dataId, group, tenant);
            try {
                return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
            }
            catch (DiamondException e) {
                log.warn(this.getName(), "[get-config] get failover fail, dataId={}, group={}, tenant={}, config={}", dataId, group, TenantUtil.getUserTenant(), ContentUtils.truncateContent(content));
                throw new IOException(e);
            }
        }
        content = LocalConfigInfoProcessor.getSnapshot(this, dataId, group, TenantUtil.getUserTenant());
        if (StringUtils.isNotEmpty(content)) {
            log.warn(this.getName(), "[get-config] get snapshot ok, dataId={}, group={}, tenant={}, config={}", dataId, group, TenantUtil.getUserTenant(), ContentUtils.truncateContent(content));
            String tenant = TenantUtil.getUserTenant();
            String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshot(this, dataId, group, tenant);
            try {
                return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
            }
            catch (DiamondException e) {
                log.warn(this.getName(), "[get-config] get snapshot fail, dataId={}, group={}, tenant={}, config={}", dataId, group, TenantUtil.getUserTenant(), ContentUtils.truncateContent(content));
                throw new IOException(e);
            }
        }
        try {
            ConfigInfo configInfo = ClientWorker.getServerConfig(this, dataId, group, timeoutMs);
            return this.doFilter(dataId, group, TenantUtil.getUserTenant(), configInfo);
        }
        catch (DiamondException e) {
            throw new IOException(e.toString());
        }
    }

    private String doFilter(String dataId, String group, String tenant, ConfigInfo configInfo) throws DiamondException {
        String content = null;
        String encryptedDataKey = null;
        if (configInfo != null) {
            content = configInfo.getContent();
            encryptedDataKey = configInfo.getEncryptedDataKey();
        }
        return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
    }

    private String doFilter(String dataId, String group, String tenant, String content, String encryptedDataKey) throws DiamondException {
        ConfigResponse cr = new ConfigResponse();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        cr.setContent(content);
        cr.setEncryptedDataKey(encryptedDataKey);
        this.configFilterChainManager.doFilter(null, cr);
        return cr.getContent();
    }

    public String getConfigFromSnapshot(String tenant, String dataId, String group) {
        String content = LocalConfigInfoProcessor.getSnapshot(this, dataId, group, tenant);
        String encryptedDataKey = LocalEncryptedDataKeyProcessor.getEncryptDataKeySnapshot(this, dataId, group, tenant);
        try {
            return this.doFilter(dataId, group, tenant, content, encryptedDataKey);
        }
        catch (DiamondException e) {
            log.warn(this.getName(), "[get-config] get snapshot fail, dataId={}, group={}, tenant={}, config={}", dataId, group, TenantUtil.getUserTenant(), ContentUtils.truncateContent(content));
            return content;
        }
    }

    public boolean publishSingle(String dataId, String group, String content) {
        return this.publishSingle(dataId, group, null, content);
    }

    public boolean publishSingleCas(String dataId, String group, String expect, String update) {
        try {
            return this.publishSingleInnerCas(TenantUtil.getUserTenant(), dataId, group, null, null, null, update, MD5.getInstance().getMD5String(expect));
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    public boolean publishSingle(String dataId, String group, String appName, String content) {
        try {
            return this.publishSingleInner(TenantUtil.getUserTenant(), dataId, group, null, appName, null, content);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    @Deprecated
    public boolean publishTenantSingle(String dataId, String group, String content) throws DiamondException {
        return this.publishSingleInner(TenantUtil.getUserTenant(), dataId, group, null, null, null, content);
    }

    public boolean publishBeta(String dataId, String group, String betaIps, String content) throws DiamondException {
        ParamUtils.checkBetaIps(betaIps);
        return this.publishBeta(dataId, group, null, betaIps, content);
    }

    public boolean publishBeta(String dataId, String group, String appName, String betaIps, String content) throws DiamondException {
        ParamUtils.checkBetaIps(betaIps);
        return this.publishSingleInner(TenantUtil.getUserTenant(), dataId, group, null, appName, betaIps, content);
    }

    @Deprecated
    public boolean publishSingle(String tenant, String dataId, String group, String appName, String content) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.publishSingleInner(tenant, dataId, group, null, appName, null, content);
    }

    @Deprecated
    public boolean publishSingleTag(String tenant, String dataId, String group, String tag, String appName, String content) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.publishSingleInner(tenant, dataId, group, tag, appName, null, content);
    }

    public boolean publishSingleTag(String dataId, String group, String tag, String appName, String content) throws DiamondException {
        return this.publishSingleInner(TenantUtil.getUserTenant(), dataId, group, tag, appName, null, content);
    }

    public boolean publishSingleTag(String dataId, String group, String tag, String content) throws DiamondException {
        return this.publishSingleInner(TenantUtil.getUserTenant(), dataId, group, tag, null, null, content);
    }

    private boolean publishSingleInner(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content) throws DiamondException {
        String encryptedDataKey;
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, content);
        if (MockServer.isTestMode()) {
            MockServer.setConfigInfo(dataId, group, content, this);
            return true;
        }
        ConfigRequest cr = new ConfigRequest();
        cr.setDataId(dataId);
        cr.setTenant(tenant);
        cr.setGroup(group);
        cr.setContent(content);
        this.configFilterChainManager.doFilter(cr, null);
        content = cr.getContent();
        String url = "/basestone.do?method=syncUpdateAll";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty(appName)) {
            params.add("appName");
            params.add(appName);
        }
        if (StringUtils.isNotEmpty(tag)) {
            params.add("tag");
            params.add(tag);
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotEmpty(betaIps)) {
            headers.add("betaIps");
            headers.add(betaIps);
        }
        if (StringUtils.isNotEmpty(encryptedDataKey = cr.getEncryptedDataKey())) {
            params.add("encryptedDataKey");
            params.add(encryptedDataKey);
        }
        HttpSimpleClient.HttpResult result = null;
        FastCompass compass = DiamondMetric.getPublishCompass();
        long start = System.currentTimeMillis();
        long end = 0L;
        try {
            result = this.agent.httpPost(url, headers, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("Diamond-0006", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0006", "\u73af\u5883\u95ee\u9898", "[publish-single] exception"));
            log.warn(this.getName(), "[publish-single] exception, dataId={}, group={}, msg={}", dataId, group, ioe.toString());
            compass.record(0L, "error");
            end = System.currentTimeMillis();
            DiamondMetric.getPublishClusterHistogram().update(end - start);
            return false;
        }
        compass.record(0L, "success");
        end = System.currentTimeMillis();
        DiamondMetric.getPublishClusterHistogram().update(end - start);
        if (200 == result.code) {
            log.info(this.getName(), "[publish-single] ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            return true;
        }
        if (403 == result.code) {
            log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
        return false;
    }

    private boolean publishSingleInnerCas(String tenant, String dataId, String group, String tag, String appName, String betaIps, String content, String md5) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, content);
        if (MockServer.isTestMode()) {
            MockServer.setConfigInfo(dataId, group, content, this);
            return true;
        }
        String url = "/basestone.do?method=syncUpdateAll";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty(appName)) {
            params.add("appName");
            params.add(appName);
        }
        if (StringUtils.isNotEmpty(tag)) {
            params.add("tag");
            params.add(tag);
        }
        if (StringUtils.isNotEmpty(md5)) {
            params.add("md5");
            params.add(md5);
        }
        ArrayList<String> headers = new ArrayList<String>();
        if (StringUtils.isNotEmpty(betaIps)) {
            headers.add("betaIps");
            headers.add(betaIps);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, headers, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("Diamond-0006", LoggerHelper.getErrorCodeStr("Diamond", "Diamond-0006", "\u73af\u5883\u95ee\u9898", "[publish-single] exception"));
            log.warn(this.getName(), "[publish-single] exception, dataId={}, group={}, msg={}", dataId, group, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[publish-single] ok, dataId={}, group={}, tenant={}, config={}", dataId, group, tenant, ContentUtils.truncateContent(content));
            return true;
        }
        if (403 == result.code) {
            log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        if (409 == result.code) {
            log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        log.warn(this.getName(), "[publish-single] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
        return false;
    }

    public boolean publishAggr(String dataId, String group, String datumId, String content) {
        return this.publishAggr(dataId, group, datumId, null, content);
    }

    public boolean publishAggr(String dataId, String group, String datumId, String appName, String content) {
        try {
            return this.publishAggrInner(TenantUtil.getUserTenant(), dataId, group, datumId, appName, content);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    @Deprecated
    public boolean publishAggr(String tenant, String dataId, String group, String datumId, String appName, String content) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.publishAggrInner(tenant, dataId, group, datumId, appName, content);
    }

    private boolean publishAggrInner(String tenant, String dataId, String group, String datumId, String appName, String content) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkParam(dataId, group, datumId, content);
        String url = "/datum.do?method=addDatum";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        params.add("datumId");
        params.add(datumId);
        params.add("content");
        params.add(content);
        if (StringUtils.isNotEmpty(appName)) {
            params.add("appName");
            params.add(appName);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[publish-aggr] exception, dataId={}, group={}, tenant={}, datumId={}, msg={}", dataId, group, tenant, datumId, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[publish-aggr] ok, dataId={}, group={}, tenant={}, datumId={}, config={}", dataId, group, tenant, datumId, ContentUtils.truncateContent(content));
            return true;
        }
        if (403 == result.code) {
            log.error(this.getName(), "[publish-aggr] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        log.error(this.getName(), "[publish-aggr] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
        return false;
    }

    public boolean removeAggr(String dataId, String group, String datumId) {
        try {
            return this.removeAggrInner(TenantUtil.getUserTenant(), dataId, group, datumId);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    @Deprecated
    public boolean removeAggr(String tenant, String dataId, String group, String datumId) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.removeAggrInner(tenant, dataId, group, datumId);
    }

    private boolean removeAggrInner(String tenant, String dataId, String group, String datumId) throws DiamondException {
        DiamondEnv.checkNotNull(dataId, datumId);
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group, datumId);
        group = this.null2defaultGroup(group);
        String url = "/datum.do?method=deleteDatum";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        params.add("datumId");
        params.add(datumId);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[remove-aggr] exception, dataId={}, group={}, tenant={}, datumId={}, msg={}", dataId, group, tenant, datumId, ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[remove-aggr] ok, dataId={}, group={}, tenant={}, datumId={}", dataId, group, tenant, datumId);
            return true;
        }
        if (403 == result.code) {
            log.error(this.getName(), "[remove-aggr] error, dataId={}, group={}, tenant={}, datumId={}, code={}, msg={}", dataId, group, tenant, datumId, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        log.error(this.getName(), "[remove-aggr] error, dataId={}, group={}, tenant={}, datumId={}, code={}, msg={}", dataId, group, tenant, datumId, result.code, result.content);
        return false;
    }

    public boolean remove(String dataId, String group) {
        try {
            return this.removeInner(TenantUtil.getUserTenant(), dataId, group, null);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    @Deprecated
    public boolean removeTenantConfig(String dataId, String group) throws DiamondException {
        return this.removeInner(TenantUtil.getUserTenant(), dataId, group, null);
    }

    public boolean remove(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.removeInner(tenant, dataId, group, null);
    }

    public boolean removeTag(String dataId, String group, String tag) {
        try {
            return this.removeInner(TenantUtil.getUserTenant(), dataId, group, tag);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return false;
        }
    }

    @Deprecated
    public boolean remove(String tenant, String dataId, String group, String tag) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.removeInner(tenant, dataId, group, tag);
    }

    private boolean removeInner(String tenant, String dataId, String group, String tag) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        if (MockServer.isTestMode()) {
            MockServer.removeConfigInfo(dataId, group, this);
            return true;
        }
        String url = "/datum.do?method=deleteAllDatums";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataId");
        params.add(dataId);
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        if (StringUtils.isNotEmpty(tag)) {
            params.add("tag");
            params.add(tag);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn("[remove] error, " + dataId + ", " + group + ", " + tenant + ", msg: " + ioe.toString());
            return false;
        }
        if (200 == result.code) {
            log.info(this.getName(), "[remove] ok, dataId={}, group={}, tenant={}", dataId, group, tenant);
            return true;
        }
        if (403 == result.code) {
            log.warn(this.getName(), "[remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        log.warn(this.getName(), "[remove] error, dataId={}, group={}, tenant={}, code={}, msg={}", dataId, group, tenant, result.code, result.content);
        return false;
    }

    public List<String> getServerUrls() {
        return new ArrayList<String>(this.serverMgr.serverUrls);
    }

    private static void checkNotNull(String ... params) {
        for (String param : params) {
            if (!StringUtils.isBlank(param)) continue;
            throw new IllegalArgumentException("param cannot be blank");
        }
    }

    private String null2defaultGroup(String group) {
        return null == group ? "DEFAULT_GROUP" : group.trim();
    }

    public BatchHttpResult<ConfigInfoEx> batchGetConfig(List<String> dataIds, String group, long timeoutMs) {
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch get config");
        }
        group = this.null2defaultGroup(group);
        try {
            return this.batchGetConfigInner(TenantUtil.getUserTenant(), dataIds, group, timeoutMs);
        }
        catch (DiamondException e) {
            if (e.getErrCode() == -400) {
                throw new IllegalArgumentException(e.toString());
            }
            if (e.getErrCode() == 403) {
                throw new AccessControlException(e.toString());
            }
            return new BatchHttpResult<ConfigInfoEx>(false, -1, "batch get config exception:" + e.toString(), "");
        }
    }

    @Deprecated
    public BatchHttpResult<ConfigInfoEx> batchGetConfig(String tenant, List<String> dataIds, String group, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.batchGetConfigInner(tenant, dataIds, group, timeoutMs);
    }

    private BatchHttpResult<ConfigInfoEx> batchGetConfigInner(String tenant, List<String> dataIds, String group, long timeoutMs) throws DiamondException {
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataIds, group);
        if (dataIds == null) {
            throw new DiamondException(-400, "dataId list is null when batch get config");
        }
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, 200, "", "mock server");
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/config.co?method=batchGetConfig";
        ArrayList<String> params = new ArrayList<String>();
        params.add("dataIds");
        params.add(dataIdstr.toString());
        params.add("group");
        params.add(group);
        if (StringUtils.isNotEmpty(tenant)) {
            params.add("tenant");
            params.add(tenant);
        }
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batch-get] exception, dataIds={}, group={}, tenant={}, msg={}", dataIds, group, tenant, ioe);
            return new BatchHttpResult<ConfigInfoEx>(false, -1, "batch get config io exception:" + ioe.getMessage(), "");
        }
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>(true, result.code, "", result.content);
        if (result.code == 200) {
            response.setSuccess(true);
            response.setStatusMsg("batch get config success");
            log.info(this.getName(), "[batch-get] ok, dataIds={}, group={}, tenant={}", dataIds, group, tenant);
        } else {
            if (403 == result.code) {
                log.warn(this.getName(), "[batch-get] error, dataIds={}, group={}, tenant={}, code={}, msg={}", dataIds, group, tenant, result.code, result.content);
                throw new DiamondException(result.code, result.content);
            }
            response.setSuccess(false);
            response.setStatusMsg("batch get config fail, status:" + result.code);
            log.warn(this.getName(), "[batch-get] error, dataIds={}, group={}, tenant={}, code={}, msg={}", dataIds, group, tenant, result.code, result.content);
        }
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<List<ConfigInfoEx>>(){});
                response.getResult().addAll((List)resultObj);
                LocalConfigInfoProcessor.batchSaveSnapshot(this, (List)resultObj);
                LocalEncryptedDataKeyProcessor.batchSaveEncryptDataKeySnapshot(this, (List)resultObj);
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch get config deserialize error");
                log.warn(this.getName(), "[batch-get] deserialize error, dataIds={}, group={}, tenant={}, msg={}", dataIds, group, tenant, e.toString());
            }
        }
        return response;
    }

    private Page<ConfigKey> getAllTenantConfigInner(String tenant, int pageNo, int pageSize, long timeoutMs) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        String url = "/basestone.do";
        ArrayList<String> params = new ArrayList<String>();
        params.add("method");
        params.add("getAllConfigByTenant");
        params.add("tenant");
        params.add(tenant);
        params.add("pageNo");
        params.add(pageNo + "");
        params.add("pageSize");
        params.add(pageSize + "");
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpGet(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException e) {
            log.warn(this.getName(), "[getAllTenantConfig] get config IOException, tenant={}", tenant);
            throw new DiamondException(result.code, "get config IOException tenant=" + tenant, e);
        }
        if (result.code != 200) {
            log.warn(this.getName(), "[getAllTenantConfig] error, tenant={}, code={}, msg={}", tenant, result.code, result.content);
            throw new DiamondException(result.code, "getConfigInfoByTenant error tenant=" + tenant + " " + result.content);
        }
        log.info(this.getName(), "[getAllTenantConfig] ok, tenant={}", tenant);
        try {
            return (Page)JSONUtils.deserializeObject(result.content, new TypeReference<Page<ConfigKey>>(){});
        }
        catch (Exception e) {
            log.warn(this.getName(), "[getAllTenantConfig] error, tenant={}, code={}, msg={}", tenant, result.code, result.content);
            throw new DiamondException(result.code, "getAllTenantConfig error tenant=" + tenant, e);
        }
    }

    public BatchHttpResult<ConfigInfoEx> batchQuery(List<String> dataIds, String group, long timeoutMs) {
        BatchHttpResult<ConfigInfoEx> response = new BatchHttpResult<ConfigInfoEx>();
        if (dataIds == null) {
            throw new IllegalArgumentException("dataId list is null when batch query");
        }
        group = this.null2defaultGroup(group);
        if (MockServer.isTestMode()) {
            List<ConfigInfoEx> result = MockServer.batchQuery(dataIds, group, this);
            response.setStatusCode(200);
            response.setResponseMsg("mock server");
            response.setSuccess(true);
            response.getResult().addAll(result);
            return response;
        }
        StringBuilder dataIdstr = new StringBuilder();
        String split = "";
        for (String dataId : dataIds) {
            dataIdstr.append(split);
            dataIdstr.append(dataId);
            split = Constants.WORD_SEPARATOR;
        }
        String url = "/admin.do?method=batchQuery";
        List<String> params = Arrays.asList("dataIds", dataIdstr.toString(), "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batch-query] exception, dataIds={}, group={}, msg={}", dataIds, group, ioe);
            response.setSuccess(false);
            response.setStatusMsg("batch query io exception\uff1a" + ioe.getMessage());
            return response;
        }
        response.setStatusCode(result.code);
        response.setResponseMsg(result.content);
        if (200 == result.code || 412 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<List<ConfigInfoEx>>(){});
                response.setSuccess(true);
                response.getResult().addAll((List)resultObj);
                log.info(this.getName(), "[batch-query] ok, dataIds={}, group={}", dataIds, group);
            }
            catch (Exception e) {
                response.setSuccess(false);
                response.setStatusMsg("batch query deserialize error");
                log.warn(this.getName(), "[batch-query] deserialize error, dataIds={}, group={}, msg={}", dataIds, group, e.toString());
            }
        } else {
            response.setSuccess(false);
            response.setStatusMsg("batch query fail, status:" + result.code);
            log.warn(this.getName(), "[batch-query] error, dataIds={}, group={}, code={}, msg={}", dataIds, group, result.code, result.content);
            return response;
        }
        return response;
    }

    public boolean stopBeta(String dataId, String group) throws DiamondException {
        return this.stopBetaInner(TenantUtil.getUserTenant(), dataId, group);
    }

    @Deprecated
    public boolean stopBeta(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.stopBetaInner(tenant, dataId, group);
    }

    private boolean stopBetaInner(String tenant, String dataId, String group) throws DiamondException {
        boolean response = false;
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        String url = "/admin.do";
        List<String> params = null;
        params = StringUtils.isBlank(tenant) ? Arrays.asList("method", "stopBeta", "dataId", dataId, "group", group) : Arrays.asList("method", "stopBeta", "tenant", tenant, "dataId", dataId, "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpGet(url, null, params, "GBK", 3000L);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[stopBeta] exception, tenant={}, dataId={}, group={}, msg={}", tenant, dataId, group, ioe);
            throw new DiamondException(500, ioe.getMessage(), ioe);
        }
        if (200 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<RestResult<Boolean>>(){});
                RestResult tmp = (RestResult)resultObj;
                if (200 != tmp.getCode()) {
                    log.warn(this.getName(), "[stopBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", tenant, dataId, group, result.code, result.content);
                    throw new DiamondException(tmp.getCode(), tmp.getMessage());
                }
                response = (Boolean)tmp.getData();
                log.info(this.getName(), "[stopBeta] ok, tenant={}, dataId={}, group={}", tenant, dataId, group);
            }
            catch (Exception e) {
                log.warn(this.getName(), "[stopBeta] deserialize error, tenant={}, dataId={} group={}, msg={}", tenant, dataId, group, e.toString());
                throw new DiamondException(500, e.getMessage(), e);
            }
        } else {
            log.warn(this.getName(), "[stopBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", tenant, dataId, group, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        return response;
    }

    public ConfigInfo4Beta getBeta(String dataId, String group) throws DiamondException {
        return this.getBetaInner(TenantUtil.getUserTenant(), dataId, group);
    }

    @Deprecated
    public ConfigInfo4Beta getBeta(String tenant, String dataId, String group) throws DiamondException {
        ParamUtils.checkTenant(tenant);
        return this.getBetaInner(tenant, dataId, group);
    }

    private ConfigInfo4Beta getBetaInner(String tenant, String dataId, String group) throws DiamondException {
        ConfigInfo4Beta response = null;
        group = this.null2defaultGroup(group);
        ParamUtils.checkKeyParam(dataId, group);
        String url = "/admin.do";
        List<String> params = null;
        params = StringUtils.isBlank(tenant) ? Arrays.asList("method", "queryBeta", "dataId", dataId, "group", group) : Arrays.asList("method", "queryBeta", "tenant", tenant, "dataId", dataId, "group", group);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpGet(url, null, params, "UTF-8", 3000L);
        }
        catch (IOException ioe) {
            throw new DiamondException(500, ioe.getMessage(), ioe);
        }
        if (200 == result.code) {
            try {
                String json = result.content;
                Object resultObj = JSONUtils.deserializeObject(json, new TypeReference<RestResult<ConfigInfo4Beta>>(){});
                RestResult tmp = (RestResult)resultObj;
                if (200 != tmp.getCode()) {
                    log.warn(this.getName(), "[getBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", tenant, dataId, group, result.code, result.content);
                    throw new DiamondException(tmp.getCode(), tmp.getMessage());
                }
                response = (ConfigInfo4Beta)tmp.getData();
                log.info(this.getName(), "[getBeta] ok, tenant={}, dataId={}, group={}", tenant, dataId, group);
            }
            catch (IOException e) {
                log.warn(this.getName(), "[getBeta] deserialize error, tenant={}, dataId={} group={}, msg={}", tenant, dataId, group, e.toString());
                throw new DiamondException(500, e.getMessage(), e);
            }
        } else {
            log.warn(this.getName(), "[getBeta] error, tenant={}, dataId={}, group={}, code={}, msg={}", tenant, dataId, group, result.code, result.content);
            throw new DiamondException(result.code, result.content);
        }
        return response;
    }

    public boolean batchRemoveAggr(String dataId, String group, List<String> datumIdList, long timeoutMs) {
        DiamondEnv.checkNotNull(dataId, group);
        if (datumIdList == null || datumIdList.isEmpty()) {
            throw new IllegalArgumentException("datumIdList cannot be blank");
        }
        StringBuilder datumStr = new StringBuilder();
        for (String datum : datumIdList) {
            datumStr.append(datum).append(Constants.WORD_SEPARATOR);
        }
        String url = "/datum.do?method=batchDeleteAggrs";
        List<String> params = Arrays.asList("dataId", dataId, "group", group, "datumList", datumStr.toString());
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
            if (result.code == 200) {
                return true;
            }
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batchRemoveAggr] exception, dataId{}, group={}, msg={}", dataId, group, ioe);
        }
        return false;
    }

    public boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) {
        return this.batchPublishAggr(dataId, group, datumMap, null, timeoutMs);
    }

    public boolean batchPublishAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) {
        DiamondEnv.checkNotNull(dataId, group);
        if (datumMap == null || datumMap.isEmpty()) {
            throw new IllegalArgumentException("datumMap cannot be blank");
        }
        StringBuilder datumStr = new StringBuilder();
        for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
            datumStr.append(datumEntry.getKey()).append(Constants.WORD_SEPARATOR).append(datumEntry.getValue()).append(Constants.LINE_SEPARATOR);
        }
        String url = "/datum.do?method=batchAddAggrs";
        List<String> params = null;
        params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString()) : Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString(), "appName", appName);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
            if (result.code == 200) {
                log.info(this.getName(), "[batchPublishAggr] ok, dataId={}, group={}", dataId, group);
                return true;
            }
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[batchPublishAggr] exception, dataId{}, group={}, msg={}", dataId, group, ioe);
        }
        return false;
    }

    public boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, long timeoutMs) {
        return this.replaceAggr(dataId, group, datumMap, null, timeoutMs);
    }

    public boolean replaceAggr(String dataId, String group, Map<String, String> datumMap, String appName, long timeoutMs) {
        DiamondEnv.checkNotNull(dataId, group);
        if (datumMap == null || datumMap.isEmpty()) {
            throw new IllegalArgumentException("datumMap cannot be blank");
        }
        StringBuilder datumStr = new StringBuilder();
        for (Map.Entry<String, String> datumEntry : datumMap.entrySet()) {
            datumStr.append(datumEntry.getKey()).append(Constants.WORD_SEPARATOR).append(datumEntry.getValue()).append(Constants.LINE_SEPARATOR);
        }
        String url = "/datum.do?method=replaceAggr";
        List<String> params = null;
        params = appName == null ? Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString()) : Arrays.asList("dataId", dataId, "group", group, "datas", datumStr.toString(), "appName", appName);
        HttpSimpleClient.HttpResult result = null;
        try {
            result = this.agent.httpPost(url, null, params, "GBK", timeoutMs);
            if (result.code == 200) {
                return true;
            }
            log.warn("response code :" + result.code + ", error message :" + result.content);
        }
        catch (IOException ioe) {
            log.warn(this.getName(), "[replaceAggr] exception, dataId{}, group={}, msg={}", dataId, group, ioe);
        }
        return false;
    }

    public CacheData getCache(String dataId, String group) {
        return this.getCache(dataId, group, TenantUtil.getUserTenant());
    }

    public CacheData getCache(String dataId, String group, String tenant) {
        if (null == dataId || null == group) {
            throw new IllegalArgumentException();
        }
        return this.cacheMap.get().get(GroupKey.getKeyTenant(dataId, group, tenant));
    }

    List<CacheData> getAllCacheDataSnapshot() {
        return new ArrayList<CacheData>(this.cacheMap.get().values());
    }

    public int getAllCacheDataSize() {
        return this.cacheMap.get().size();
    }

    public List<String> getAllListeners() {
        return new ArrayList<String>(this.cacheMap.get().keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, TenantUtil.getUserTenant());
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[unsubscribe] {}", groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeCache(String dataId, String group, String tenant) {
        String groupKey = GroupKey.getKeyTenant(dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.remove(groupKey);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[unsubscribe] {}", groupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group) {
        CacheData cache = this.getCache(dataId, group);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKeyTenant(dataId, group, TenantUtil.getUserTenant());
        cache = new CacheData(this, dataId, group);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            } else {
                int taskId = this.getAllCacheDataSize() / (int)this.getPER_TASK_CONFIG_SIZE();
                cache.setTaskId(taskId);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[subscribe] {}", key);
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheData addCacheDataIfAbsent(String dataId, String group, String tenant) {
        CacheData cache = this.getCache(dataId, group, tenant);
        if (null != cache) {
            return cache;
        }
        String key = GroupKey.getKeyTenant(dataId, group, tenant);
        cache = new CacheData(this, dataId, group, tenant);
        AtomicReference<Map<String, CacheData>> atomicReference = this.cacheMap;
        synchronized (atomicReference) {
            CacheData cacheFromMap = this.getCache(dataId, group, tenant);
            if (null != cacheFromMap) {
                cache = cacheFromMap;
                cache.setInitializing(true);
            }
            HashMap<String, CacheData> copy = new HashMap<String, CacheData>(this.cacheMap.get());
            copy.put(key, cache);
            this.cacheMap.set(copy);
        }
        log.info(this.getName(), "[subscribe] {}", key);
        return cache;
    }

    public Set<String> getSubscribeDataIds() {
        Map<String, CacheData> cacheMapSnapshot = this.cacheMap.get();
        HashSet<String> dataIds = new HashSet<String>(cacheMapSnapshot.size());
        for (CacheData cache : cacheMapSnapshot.values()) {
            dataIds.add(cache.dataId);
        }
        return dataIds;
    }

    public String toString() {
        return "DiamondEnv-" + this.serverMgr.toString();
    }

    public ServerListManager getServerMgr() {
        return this.serverMgr;
    }

    public String getName() {
        return this.serverMgr.name;
    }

    public ServerHttpAgent getAgent() {
        return this.agent;
    }

    public ClientWorker getWorker() {
        return this.worker;
    }

    public void initServerManager(ServerListManager _serverMgr) {
        _serverMgr.setEnv(this);
        this.serverMgr = _serverMgr;
        this.serverMgr.start();
        this.agent = new ServerHttpAgent(this.serverMgr);
    }

    public double getPER_TASK_CONFIG_SIZE() {
        return this.PER_TASK_CONFIG_SIZE;
    }

    public void setPER_TASK_CONFIG_SIZE(double pER_TASK_CONFIG_SIZE) {
        this.PER_TASK_CONFIG_SIZE = pER_TASK_CONFIG_SIZE;
    }

    public DiamondEnv(String ... serverIps) {
        this(new ServerListManager(Arrays.asList(serverIps)));
    }

    public void addConfigFilter(IConfigFilter configFilter) {
        this.configFilterChainManager.addFilter(configFilter);
    }

    public ConfigFilterChainManager getConfigFilterChainManager() {
        return this.configFilterChainManager;
    }

    protected DiamondEnv(ServerListManager serverListMgr) {
        serverListMgr.setEnv(this);
        try {
            this.PER_TASK_CONFIG_SIZE = Double.valueOf(System.getProperty("PER_TASK_CONFIG_SIZE", "3000"));
            log.warn("PER_TASK_CONFIG_SIZE:", this.PER_TASK_CONFIG_SIZE);
        }
        catch (Throwable t) {
            log.error("PER_TASK_CONFIG_SIZE", "PER_TASK_CONFIG_SIZE invalid", t);
        }
        this.initServerManager(serverListMgr);
        this.cacheMap = new AtomicReference(new HashMap());
        this.worker = new ClientWorker(this);
    }
}

