/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.command;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONArray;
import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSONObject;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiDefinition;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPathPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.ApiPredicateItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.api.GatewayApiDefinitionManager;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.datasource.WritableDataSource;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.URLDecoder;
import java.util.HashSet;
import java.util.Set;

@CommandMapping(name="gateway/updateApiDefinitions", desc="")
public class UpdateGatewayApiDefinitionGroupCommandHandler
implements CommandHandler<String> {
    private static WritableDataSource<Set<ApiDefinition>> apiDefinitionWds = null;
    private static final String SUCCESS_MSG = "success";
    private static final String WRITE_DS_FAILURE_MSG = "partial success (write data source failed)";

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank(data)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("Bad data"));
        }
        try {
            data = URLDecoder.decode(data, "utf-8");
        }
        catch (Exception e) {
            RecordLog.info("Decode gateway API definition data error", e);
            return CommandResponse.ofFailure(e, "decode gateway API definition data error");
        }
        RecordLog.info("[API Server] Receiving data change (type: gateway API definition): {0}", data);
        String result = SUCCESS_MSG;
        Set<ApiDefinition> apiDefinitions = this.parseJson(data);
        GatewayApiDefinitionManager.loadApiDefinitions(apiDefinitions);
        if (!this.writeToDataSource(apiDefinitionWds, apiDefinitions)) {
            result = WRITE_DS_FAILURE_MSG;
        }
        return CommandResponse.ofSuccess(result);
    }

    private Set<ApiDefinition> parseJson(String data) {
        HashSet<ApiDefinition> apiDefinitions = new HashSet<ApiDefinition>();
        JSONArray array = JSON.parseArray(data);
        for (Object obj : array) {
            JSONObject o = (JSONObject)obj;
            ApiDefinition apiDefinition = new ApiDefinition(o.getString("apiName"));
            HashSet<ApiPredicateItem> predicateItems = new HashSet<ApiPredicateItem>();
            JSONArray itemArray = o.getJSONArray("predicateItems");
            if (itemArray != null) {
                predicateItems.addAll(itemArray.toJavaList(ApiPathPredicateItem.class));
            }
            apiDefinition.setPredicateItems(predicateItems);
            apiDefinitions.add(apiDefinition);
        }
        return apiDefinitions;
    }

    private <T> boolean writeToDataSource(WritableDataSource<T> dataSource, T value) {
        if (dataSource != null) {
            try {
                dataSource.write(value);
            }
            catch (Exception e) {
                RecordLog.warn("Write data source failed", e);
                return false;
            }
        }
        return true;
    }

    public static synchronized WritableDataSource<Set<ApiDefinition>> getWritableDataSource() {
        return apiDefinitionWds;
    }

    public static synchronized void setWritableDataSource(WritableDataSource<Set<ApiDefinition>> apiDefinitionWds) {
        UpdateGatewayApiDefinitionGroupCommandHandler.apiDefinitionWds = apiDefinitionWds;
    }
}

