/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.sentinel.arms.AsyncQueueingExecutor;
import com.alibaba.csp.sentinel.arms.AsyncQueueingExecutorListener;
import com.alibaba.csp.sentinel.arms.DataSender;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.FutureListener;
import com.navercorp.pinpoint.rpc.ResponseMessage;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseDeserializer;
import com.navercorp.pinpoint.thrift.io.HeaderTBaseSerializer;
import com.navercorp.pinpoint.thrift.util.SerializationUtils;
import java.util.Collection;

public abstract class AbstractDataSender
implements DataSender {
    private PLogger logger = PLoggerFactory.getLogger(this.getClass());

    protected abstract void sendPacket(Object var1);

    protected void sendPacketN(Collection<Object> messageList) {
        Object[] dataList = messageList.toArray();
        int size = messageList.size();
        for (int i = 0; i < size; ++i) {
            try {
                this.sendPacket(dataList[i]);
                continue;
            }
            catch (Throwable th) {
                this.logger.warn("Unexpected Error. Cause:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected AsyncQueueingExecutor<Object> createAsyncQueueingExecutor(int queueSize, String executorName) {
        AsyncQueueingExecutor<Object> executor = new AsyncQueueingExecutor<Object>(queueSize, executorName);
        executor.setListener(new AsyncQueueingExecutorListener<Object>(){

            @Override
            public void execute(Collection<Object> messageList) {
                AbstractDataSender.this.sendPacketN(messageList);
            }

            @Override
            public void execute(Object message) {
                AbstractDataSender.this.sendPacket(message);
            }
        });
        return executor;
    }

    protected byte[] serialize(HeaderTBaseSerializer serializer, TBase tBase) {
        return SerializationUtils.serialize(tBase, serializer, null);
    }

    protected TBase<?, ?> deserialize(HeaderTBaseDeserializer deserializer, ResponseMessage responseMessage) {
        byte[] message = responseMessage.getMessage();
        return SerializationUtils.deserialize(message, deserializer, null);
    }

    protected static class RequestMarker {
        private final TBase tBase;
        private final int retryCount;
        private final FutureListener futureListener;

        protected RequestMarker(TBase tBase, int retryCount) {
            this.tBase = tBase;
            this.retryCount = retryCount;
            this.futureListener = null;
        }

        protected RequestMarker(TBase tBase, FutureListener futureListener) {
            this.tBase = tBase;
            this.retryCount = 3;
            this.futureListener = futureListener;
        }

        protected TBase getTBase() {
            return this.tBase;
        }

        protected int getRetryCount() {
            return this.retryCount;
        }

        protected FutureListener getFutureListener() {
            return this.futureListener;
        }
    }
}

