/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.arms;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.sentinel.arms.AgentInfoSenderListener;
import com.alibaba.csp.sentinel.arms.ArmsServerConstants;
import com.alibaba.csp.sentinel.arms.TcpDataSender;
import com.alibaba.csp.sentinel.arms.VpcEcsUtil;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;

public class ArmsDataSender {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final String AHAS_SENTINEL_GATEWAY_SENDER = "ahas_sentinel_gateway_sender";
    private static String endpoint;
    private static final int INITIAL_SENDER_PORT = 8442;
    private static final int METRIC_SENDER_PORT = 8443;
    private AgentInfoSenderListener senderListener = new AgentInfoSenderListener();
    private static ArmsDataSender armsDataSender;
    private TcpDataSender metricSender;
    private TcpDataSender initialSender;

    private ArmsDataSender() {
        this.initArmsEndpoint();
        this.initArmsSender();
    }

    public static synchronized ArmsDataSender getInstance() {
        if (armsDataSender == null) {
            armsDataSender = new ArmsDataSender();
        }
        return armsDataSender;
    }

    private void initArmsEndpoint() {
        endpoint = System.getProperty("arms.server.address");
        if (endpoint != null) {
            return;
        }
        String regionId = VpcEcsUtil.getUid() != null ? VpcEcsUtil.getRegionId() + "-internal" : "cn-public";
        endpoint = ArmsServerConstants.SERVER_ADDRESS.get(regionId);
        if (endpoint == null) {
            this.logger.error("Init arms endpoint failed: endpoint is null.");
        }
    }

    private void initArmsSender() {
        this.initialSender = new TcpDataSender(AHAS_SENTINEL_GATEWAY_SENDER, endpoint, 8442, new DefaultPinpointClientFactory());
        this.metricSender = new TcpDataSender(AHAS_SENTINEL_GATEWAY_SENDER, endpoint, 8443, new DefaultPinpointClientFactory());
    }

    public boolean sendMetricData(TBase data) {
        return this.metricSender.send(data);
    }

    public boolean sendSpanStatData(TBase data) {
        return this.initialSender.send(data);
    }

    public boolean sendInitialData(TBase data) {
        return this.initialSender.request(data, this.senderListener);
    }
}

