/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.arms;

public class RetryMessage {
    private int retryCount = 0;
    private final int maxRetryCount;
    private final byte[] bytes;
    private final String messageDescription;

    public RetryMessage(int maxRetryCount, byte[] bytes) {
        this(0, maxRetryCount, bytes, "");
    }

    public RetryMessage(int retryCount, int maxRetryCount, byte[] bytes) {
        this(retryCount, maxRetryCount, bytes, "");
    }

    public RetryMessage(int maxRetryCount, byte[] bytes, String messageDescription) {
        this(0, maxRetryCount, bytes, messageDescription);
    }

    public RetryMessage(int retryCount, int maxRetryCount, byte[] bytes, String messageDescription) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("retryCount:" + retryCount + " must be positive number");
        }
        if (maxRetryCount < 0) {
            throw new IllegalArgumentException("maxRetryCount:" + maxRetryCount + " must be positive number");
        }
        if (retryCount > maxRetryCount) {
            throw new IllegalArgumentException("maxRetryCount(" + maxRetryCount + ") must be greater than retryCount(" + retryCount + ")");
        }
        this.retryCount = retryCount;
        this.maxRetryCount = maxRetryCount;
        this.bytes = bytes;
        this.messageDescription = messageDescription;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public boolean isRetryAvailable() {
        return this.retryCount < this.maxRetryCount;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int fail() {
        return ++this.retryCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RetryMessage{");
        sb.append("retryCount=").append(this.retryCount);
        sb.append(", maxRetryCount=").append(this.maxRetryCount);
        sb.append(", bytes=").append(this.getLength(this.bytes));
        sb.append(", messageDescription='").append(this.messageDescription).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private int getLength(byte[] bytes) {
        if (bytes == null) {
            return -1;
        }
        return bytes.length;
    }
}

