/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.flow.statistic.metric;

import com.alibaba.csp.sentinel.cluster.flow.statistic.metric.ClusterParameterLeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.LongAdder;
import com.alibaba.csp.sentinel.slots.statistic.cache.CacheMap;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClusterParamMetric {
    public static final int DEFAULT_CLUSTER_MAX_CAPACITY = 4000;
    private final ClusterParameterLeapArray<LongAdder> metric;

    public ClusterParamMetric(int sampleCount, int intervalInMs) {
        this(sampleCount, intervalInMs, 4000);
    }

    public ClusterParamMetric(int sampleCount, int intervalInMs, int maxCapacity) {
        AssertUtil.isTrue(sampleCount > 0, "sampleCount should be positive");
        AssertUtil.isTrue(intervalInMs > 0, "interval should be positive");
        AssertUtil.isTrue(intervalInMs % sampleCount == 0, "time span needs to be evenly divided");
        this.metric = new ClusterParameterLeapArray(sampleCount, intervalInMs, maxCapacity);
    }

    public long getSum(Object value) {
        if (value == null) {
            return 0L;
        }
        this.metric.currentWindow();
        long sum = 0L;
        List buckets = this.metric.values();
        for (CacheMap bucket : buckets) {
            long count = this.getCount((LongAdder)bucket.get(value));
            sum += count;
        }
        return sum;
    }

    private long getCount(LongAdder adder) {
        return adder == null ? 0L : adder.sum();
    }

    public void addValue(Object value, int count) {
        LongAdder newCounter;
        if (value == null) {
            return;
        }
        CacheMap data = (CacheMap)this.metric.currentWindow().value();
        LongAdder currentCounter = data.putIfAbsent(value, newCounter = new LongAdder());
        if (currentCounter != null) {
            currentCounter.add(count);
        } else {
            newCounter.add(count);
        }
    }

    public double getAvg(Object value) {
        return (double)this.getSum(value) / this.metric.getIntervalInSecond();
    }

    public Map<Object, Double> getTopValues(int number) {
        Map.Entry x;
        this.metric.currentWindow();
        List buckets = this.metric.values();
        HashMap result = new HashMap(buckets.size());
        for (CacheMap b : buckets) {
            Set subSet = b.keySet(true);
            for (Object o : subSet) {
                Long count = (Long)result.get(o);
                count = count == null ? Long.valueOf(this.getCount((LongAdder)b.get(o))) : Long.valueOf(count + this.getCount((LongAdder)b.get(o)));
                result.put(o, count);
            }
        }
        Set set = result.entrySet();
        ArrayList list = new ArrayList(set);
        Collections.sort(list, new Comparator<Map.Entry<Object, Long>>(){

            @Override
            public int compare(Map.Entry<Object, Long> a, Map.Entry<Object, Long> b) {
                return (int)(b.getValue() == null ? 0L : b.getValue()) - (int)(a.getValue() == null ? 0L : a.getValue());
            }
        });
        HashMap<Object, Double> doubleResult = new HashMap<Object, Double>();
        int size = list.size() > number ? number : list.size();
        for (int i = 0; i < size && (Long)(x = (Map.Entry)list.get(i)).getValue() != 0L; ++i) {
            doubleResult.put(x.getKey(), (double)((Long)x.getValue()).longValue() / this.metric.getIntervalInSecond());
        }
        return doubleResult;
    }
}

