/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.codec;

import com.alibaba.csp.sentinel.cluster.codec.request.RequestEntityDecoder;
import com.alibaba.csp.sentinel.cluster.codec.response.ResponseEntityWriter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.SpiLoader;

public final class ServerEntityCodecProvider {
    private static RequestEntityDecoder requestEntityDecoder = null;
    private static ResponseEntityWriter responseEntityWriter = null;

    private static void resolveInstance() {
        ResponseEntityWriter writer = SpiLoader.loadFirstInstance(ResponseEntityWriter.class);
        if (writer == null) {
            RecordLog.warn("[ServerEntityCodecProvider] No existing response entity writer, resolve failed", new Object[0]);
        } else {
            responseEntityWriter = writer;
            RecordLog.info("[ServerEntityCodecProvider] Response entity writer resolved: " + responseEntityWriter.getClass().getCanonicalName(), new Object[0]);
        }
        RequestEntityDecoder decoder = SpiLoader.loadFirstInstance(RequestEntityDecoder.class);
        if (decoder == null) {
            RecordLog.warn("[ServerEntityCodecProvider] No existing request entity decoder, resolve failed", new Object[0]);
        } else {
            requestEntityDecoder = decoder;
            RecordLog.info("[ServerEntityCodecProvider] Request entity decoder resolved: " + requestEntityDecoder.getClass().getCanonicalName(), new Object[0]);
        }
    }

    public static RequestEntityDecoder getRequestEntityDecoder() {
        return requestEntityDecoder;
    }

    public static ResponseEntityWriter getResponseEntityWriter() {
        return responseEntityWriter;
    }

    private ServerEntityCodecProvider() {
    }

    static {
        ServerEntityCodecProvider.resolveInstance();
    }
}

