/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.cluster.server.command.handler;

import com.alibaba.csp.ahas.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.csp.sentinel.cluster.server.config.ClusterServerConfigManager;
import com.alibaba.csp.sentinel.cluster.server.config.ServerFlowConfig;
import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.net.URLDecoder;

@CommandMapping(name="cluster/server/modifyFlowConfig", desc="modify cluster server flow config")
public class ModifyClusterServerFlowConfigHandler
implements CommandHandler<String> {
    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String data = request.getParam("data");
        if (StringUtil.isBlank(data)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("empty data"));
        }
        String namespace = request.getParam("namespace");
        try {
            data = URLDecoder.decode(data, "utf-8");
            if (StringUtil.isEmpty(namespace)) {
                RecordLog.info("[ModifyClusterServerFlowConfigHandler] Receiving cluster server global flow config: " + data, new Object[0]);
                ServerFlowConfig config = JSON.parseObject(data, ServerFlowConfig.class);
                if (!ClusterServerConfigManager.isValidFlowConfig(config)) {
                    CommandResponse.ofFailure(new IllegalArgumentException("Bad flow config"));
                }
                ClusterServerConfigManager.loadGlobalFlowConfig(config);
            } else {
                RecordLog.info("[ModifyClusterServerFlowConfigHandler] Receiving cluster server flow config for namespace <{0}>: {1}", namespace, data);
                ServerFlowConfig config = JSON.parseObject(data, ServerFlowConfig.class);
                if (!ClusterServerConfigManager.isValidFlowConfig(config)) {
                    CommandResponse.ofFailure(new IllegalArgumentException("Bad flow config"));
                }
                ClusterServerConfigManager.loadFlowConfig(namespace, config);
            }
            return CommandResponse.ofSuccess("success");
        }
        catch (Exception e) {
            RecordLog.warn("[ModifyClusterServerFlowConfigHandler] Decode cluster server flow config error", e);
            return CommandResponse.ofFailure(e, "decode cluster server flow config error");
        }
    }
}

