/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.config;

import com.alibaba.csp.sentinel.config.SentinelConfigLoader;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.util.AppNameUtil;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public final class SentinelConfig {
    public static final int APP_TYPE_COMMON = 0;
    private static final Map<String, String> props = new ConcurrentHashMap<String, String>();
    private static int appType = 0;
    public static final String APP_TYPE = "csp.sentinel.app.type";
    public static final String CHARSET = "csp.sentinel.charset";
    public static final String SINGLE_METRIC_FILE_SIZE = "csp.sentinel.metric.file.single.size";
    public static final String TOTAL_METRIC_FILE_COUNT = "csp.sentinel.metric.file.total.count";
    public static final String COLD_FACTOR = "csp.sentinel.flow.cold.factor";
    public static final String STATISTIC_MAX_RT = "csp.sentinel.statistic.max.rt";
    public static final String SPI_CLASSLOADER = "csp.sentinel.spi.classloader";
    public static final String MAX_RESOURCE_COUNT_PROPERTY_KEY = "csp.sentinel.resource.amount.limit";
    public static final String MAX_CONTEXT_COUNT_PROPERTY_KEY = "csp.sentinel.context.amount.limit";
    public static final String MAX_ORIGIN_COUNT_PROPERTY_KEY = "csp.sentinel.statistic.origin.amount.limit";
    public static final String METRIC_LOG_FLUSH_INTERVAL_PROPERTY_KEY = "csp.sentinel.metric.flush.interval";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final long DEFAULT_SINGLE_METRIC_FILE_SIZE = 0x3200000L;
    public static final int DEFAULT_TOTAL_METRIC_FILE_COUNT = 6;
    public static final int DEFAULT_METRIC_LOG_FLUSH_INTERVAL = 1;
    public static final int DEFAULT_METRIC_LOG_FLUSH_QUEUE_SIZE = 60;
    public static final int DEFAULT_COLD_FACTOR = 3;
    public static final int DEFAULT_STATISTIC_MAX_RT = 4900;

    private static void resolveAppType() {
        try {
            String type = SentinelConfig.getConfig(APP_TYPE);
            if (type == null) {
                appType = 0;
                return;
            }
            appType = Integer.parseInt(type);
            if (appType < 0) {
                appType = 0;
            }
        }
        catch (Exception ex) {
            appType = 0;
        }
    }

    private static void initialize() {
        SentinelConfig.setConfig(CHARSET, DEFAULT_CHARSET);
        SentinelConfig.setConfig(SINGLE_METRIC_FILE_SIZE, String.valueOf(0x3200000L));
        SentinelConfig.setConfig(TOTAL_METRIC_FILE_COUNT, String.valueOf(6));
        SentinelConfig.setConfig(COLD_FACTOR, String.valueOf(3));
        SentinelConfig.setConfig(STATISTIC_MAX_RT, String.valueOf(4900));
        SentinelConfig.setConfig(METRIC_LOG_FLUSH_INTERVAL_PROPERTY_KEY, String.valueOf(1));
        SentinelConfig.setConfig(MAX_RESOURCE_COUNT_PROPERTY_KEY, String.valueOf(6000));
        SentinelConfig.setConfig(MAX_CONTEXT_COUNT_PROPERTY_KEY, String.valueOf(2000));
        SentinelConfig.setConfig(MAX_ORIGIN_COUNT_PROPERTY_KEY, String.valueOf(1000));
    }

    private static void loadProps() {
        Properties properties = SentinelConfigLoader.getProperties();
        for (Object key : properties.keySet()) {
            SentinelConfig.setConfig((String)key, (String)properties.get(key));
        }
    }

    public static String getConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.get(key);
    }

    public static void setConfig(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        props.put(key, value);
    }

    public static String removeConfig(String key) {
        AssertUtil.notNull(key, "key cannot be null");
        return props.remove(key);
    }

    public static void setConfigIfAbsent(String key, String value) {
        AssertUtil.notNull(key, "key cannot be null");
        AssertUtil.notNull(value, "value cannot be null");
        String v = props.get(key);
        if (v == null) {
            props.put(key, value);
        }
    }

    public static String getAppName() {
        return AppNameUtil.getAppName();
    }

    public static int getAppType() {
        return appType;
    }

    public static String charset() {
        return props.get(CHARSET);
    }

    public static long singleMetricFileSize() {
        try {
            return Long.parseLong(props.get(SINGLE_METRIC_FILE_SIZE));
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse singleMetricFileSize fail, use default value: 52428800", throwable);
            return 0x3200000L;
        }
    }

    public static int totalMetricFileCount() {
        try {
            return Integer.parseInt(props.get(TOTAL_METRIC_FILE_COUNT));
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse totalMetricFileCount fail, use default value: 6", throwable);
            return 6;
        }
    }

    public static int coldFactor() {
        try {
            int coldFactor = Integer.parseInt(props.get(COLD_FACTOR));
            if (coldFactor <= 1) {
                coldFactor = 3;
                RecordLog.warn("cold factor=" + coldFactor + ", should be larger than 1, use default value: " + 3, new Object[0]);
            }
            return coldFactor;
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Parse coldFactor fail, use default value: 3", throwable);
            return 3;
        }
    }

    public static int statisticMaxRt() {
        return SentinelConfig.getIntOrSetDefault(STATISTIC_MAX_RT, 4900);
    }

    public static int maxResourceAmount() {
        return SentinelConfig.getIntOrSetDefault(MAX_RESOURCE_COUNT_PROPERTY_KEY, 6000);
    }

    public static int maxOriginAmount() {
        return SentinelConfig.getIntOrSetDefault(MAX_ORIGIN_COUNT_PROPERTY_KEY, 1000);
    }

    public static int maxEntranceContextAmount() {
        return SentinelConfig.getIntOrSetDefault(MAX_CONTEXT_COUNT_PROPERTY_KEY, 2000);
    }

    public static int metricLogFlushIntervalSec() {
        return SentinelConfig.getIntOrSetDefault(METRIC_LOG_FLUSH_INTERVAL_PROPERTY_KEY, 1);
    }

    private static int getIntOrSetDefault(String key, int defaultValue) {
        AssertUtil.assertNotBlank(key, "key cannot be blank");
        String v = props.get(key);
        try {
            if (StringUtil.isEmpty(v)) {
                return defaultValue;
            }
            return Integer.parseInt(v);
        }
        catch (Throwable throwable) {
            RecordLog.warn("[SentinelConfig] Invalid {0} value: {1}, using the default value instead: " + defaultValue, key, v, throwable);
            SentinelConfig.setConfig(key, String.valueOf(defaultValue));
            return defaultValue;
        }
    }

    private SentinelConfig() {
    }

    static {
        try {
            SentinelConfig.initialize();
            SentinelConfig.loadProps();
            SentinelConfig.resolveAppType();
            RecordLog.info("[SentinelConfig] Application type resolved: " + appType, new Object[0]);
        }
        catch (Throwable ex) {
            RecordLog.warn("[SentinelConfig] Failed to initialize", ex);
            ex.printStackTrace();
        }
    }
}

