/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.context;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextNameDefineException;
import com.alibaba.csp.sentinel.context.NullContext;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.DefaultNode;
import com.alibaba.csp.sentinel.node.EntranceNode;
import com.alibaba.csp.sentinel.slotchain.StringResourceWrapper;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;

public class ContextUtil {
    private static ThreadLocal<Context> contextHolder = new ThreadLocal();
    private static volatile Map<String, DefaultNode> contextNameNodeMap = new HashMap<String, DefaultNode>();
    private static final ReentrantLock LOCK = new ReentrantLock();
    private static final Context NULL_CONTEXT = new NullContext();
    private static boolean shouldWarn;

    private static void initDefaultContext() {
        String defaultContextName = "sentinel_default_context";
        EntranceNode node = new EntranceNode(new StringResourceWrapper(defaultContextName, EntryType.IN), null);
        Constants.ROOT.addChild(node);
        contextNameNodeMap.put(defaultContextName, node);
    }

    static void resetContextMap() {
        if (contextNameNodeMap != null) {
            RecordLog.warn("Context map cleared and reset to initial state", new Object[0]);
            contextNameNodeMap.clear();
            ContextUtil.initDefaultContext();
        }
    }

    public static Context enter(String name, String origin) {
        if ("sentinel_default_context".equals(name)) {
            throw new ContextNameDefineException("The sentinel_default_context can't be permit to defined!");
        }
        return ContextUtil.trueEnter(name, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Context trueEnter(String name, String origin) {
        Context context = contextHolder.get();
        if (context == null) {
            Map<String, DefaultNode> localCacheNameMap = contextNameNodeMap;
            DefaultNode node = localCacheNameMap.get(name);
            if (node == null) {
                int maxContextLimit = SentinelConfig.maxEntranceContextAmount();
                if (localCacheNameMap.size() > maxContextLimit) {
                    ContextUtil.setNullContext();
                    return NULL_CONTEXT;
                }
                LOCK.lock();
                try {
                    node = contextNameNodeMap.get(name);
                    if (node == null) {
                        if (contextNameNodeMap.size() > maxContextLimit) {
                            ContextUtil.setNullContext();
                            Context context2 = NULL_CONTEXT;
                            return context2;
                        }
                        node = new EntranceNode(new StringResourceWrapper(name, EntryType.IN), null);
                        Constants.ROOT.addChild(node);
                        HashMap<String, DefaultNode> newMap = new HashMap<String, DefaultNode>(contextNameNodeMap.size() + 1);
                        newMap.putAll(contextNameNodeMap);
                        newMap.put(name, node);
                        contextNameNodeMap = newMap;
                    }
                }
                finally {
                    LOCK.unlock();
                }
            }
            context = new Context(node, name);
            context.setOrigin(origin);
            contextHolder.set(context);
        }
        return context;
    }

    private static void setNullContext() {
        contextHolder.set(NULL_CONTEXT);
        if (shouldWarn) {
            RecordLog.warn("[SentinelStatusChecker] WARN: Amount of context exceeds the threshold " + SentinelConfig.maxEntranceContextAmount() + ". Entries in new contexts will NOT take effect!", new Object[0]);
            shouldWarn = false;
        }
    }

    public static Context enter(String name) {
        return ContextUtil.enter(name, "");
    }

    public static void exit() {
        Context context = contextHolder.get();
        if (context != null && context.getCurEntry() == null) {
            contextHolder.set(null);
        }
    }

    public static int contextSize() {
        return contextNameNodeMap.size();
    }

    public static boolean isDefaultContext(Context context) {
        if (context == null) {
            return false;
        }
        return "sentinel_default_context".equals(context.getName());
    }

    public static Context getContext() {
        return contextHolder.get();
    }

    static Context replaceContext(Context newContext) {
        Context backupContext = contextHolder.get();
        if (newContext == null) {
            contextHolder.remove();
        } else {
            contextHolder.set(newContext);
        }
        return backupContext;
    }

    public static void runOnContext(Context context, Runnable f) {
        Context curContext = ContextUtil.replaceContext(context);
        try {
            f.run();
        }
        finally {
            ContextUtil.replaceContext(curContext);
        }
    }

    static {
        ContextUtil.initDefaultContext();
        shouldWarn = true;
    }
}

