/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.node.metric;

import com.alibaba.csp.sentinel.Constants;
import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.node.metric.MetricNode;
import com.alibaba.csp.sentinel.node.metric.MetricWriter;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.csp.sentinel.util.TimeUtil;
import com.alibaba.csp.sentinel.util.function.Predicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MetricAggregatorTask
implements Runnable {
    private static final ExecutorService POOL = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(60), new NamedThreadFactory("sentinel-metric-log-writer-task", true), new ThreadPoolExecutor.DiscardOldestPolicy());
    private final MetricWriter metricWriter = new MetricWriter(SentinelConfig.singleMetricFileSize(), SentinelConfig.totalMetricFileCount());
    private long lastFetchTime = -1L;

    @Override
    public void run() {
        long currentTime = TimeUtil.currentTimeMillis();
        if ((currentTime -= currentTime % 1000L) <= this.lastFetchTime) {
            return;
        }
        final TreeMap<Long, List<MetricNode>> maps = new TreeMap<Long, List<MetricNode>>();
        for (Map.Entry<ResourceWrapper, ClusterNode> e : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            ClusterNode node = e.getValue();
            Map<Long, MetricNode> metrics = this.currentMetricItems(node, currentTime);
            this.aggregate(maps, metrics, node);
        }
        this.aggregate(maps, this.currentMetricItems(Constants.ENTRY_NODE, currentTime), Constants.ENTRY_NODE);
        this.lastFetchTime = currentTime;
        if (!maps.isEmpty()) {
            POOL.submit(new Runnable(){

                @Override
                public void run() {
                    for (Map.Entry entry : maps.entrySet()) {
                        try {
                            MetricAggregatorTask.this.metricWriter.write((Long)entry.getKey(), (List)entry.getValue());
                        }
                        catch (Throwable e) {
                            RecordLog.warn("[MetricAggregatorTask] Write metric error", e);
                        }
                    }
                }
            });
        }
    }

    private boolean isActiveMetricItem(MetricNode item) {
        return item.getPassQps() > 0L || item.getBlockQps() > 0L || item.getSuccessQps() > 0L || item.getExceptionQps() > 0L || item.getRt() > 0L || item.getOccupiedPassQps() > 0L;
    }

    private boolean isNodeTimestampInTime(long ts, long currentSecondStart) {
        return ts >= this.lastFetchTime && ts < currentSecondStart;
    }

    private Map<Long, MetricNode> currentMetricItems(ClusterNode node, final long currentTime) {
        HashMap<Long, MetricNode> metrics = new HashMap<Long, MetricNode>(2);
        List<MetricNode> metricItems = node.rawMetricsInMin(new Predicate<Long>(){

            @Override
            public boolean test(Long ts) {
                return MetricAggregatorTask.this.isNodeTimestampInTime(ts, currentTime);
            }
        });
        for (MetricNode item : metricItems) {
            if (!this.isActiveMetricItem(item)) continue;
            item.setConcurrency(node.curThreadNum());
            metrics.put(item.getTimestamp(), item);
        }
        return metrics;
    }

    private void aggregate(Map<Long, List<MetricNode>> maps, Map<Long, MetricNode> metrics, ClusterNode node) {
        for (Map.Entry<Long, MetricNode> entry : metrics.entrySet()) {
            long time = entry.getKey();
            MetricNode metricNode = entry.getValue();
            metricNode.setResource(node.getName());
            metricNode.setClassification(node.getResourceType());
            if (maps.get(time) == null) {
                maps.put(time, new ArrayList());
            }
            List<MetricNode> nodes = maps.get(time);
            nodes.add(entry.getValue());
        }
    }
}

