/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.Appender;
import com.navercorp.pinpoint.common.arms.logger.ArmsAgentLoggerEncoder;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerUtils;
import com.navercorp.pinpoint.common.arms.logger.AsyncAppender;
import com.navercorp.pinpoint.common.arms.logger.BaseContext;
import com.navercorp.pinpoint.common.arms.logger.FormattingTuple;
import com.navercorp.pinpoint.common.arms.logger.LogDaemon;
import com.navercorp.pinpoint.common.arms.logger.LogLevel;
import com.navercorp.pinpoint.common.arms.logger.LogType;
import com.navercorp.pinpoint.common.arms.logger.MessageFormatter;
import com.navercorp.pinpoint.common.arms.logger.RollingFileAppender;
import com.navercorp.pinpoint.common.arms.logger.SyncAppender;
import com.navercorp.pinpoint.common.arms.logger.TokenBucket;
import com.navercorp.pinpoint.common.arms.util.logger.ArmsApmConstants;
import com.navercorp.pinpoint.common.util.PropertyUtils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ArmsLogger {
    private static final AtomicBoolean initFlag = new AtomicBoolean(false);
    static final String AGENT_HOME = ArmsLogger.locateAgentDir();
    public static Properties properties = ArmsLogger.readConfigProperties();
    static final String BASE_LOG_DIR = ArmsLogger.locateBaseLogPath();
    static final String LOG_PATH = ArmsLogger.locateARMSLogDirPath();
    static final Charset DEFAULT_CHARSET = ArmsLogger.getDefaultOutputCharset();
    static final String ARMSLOGGER_SELF_LOG_FILE = ArmsLogger.locateARMSSelfLogPath();
    static final String ARMSLOGGER_LOG_FILE = ArmsLogger.locateARMSLogPath();
    static final String CONFIG_LOG_LEVEL = ArmsLogger.getLogLevel();
    static AsyncAppender bizAppender;
    static Appender selfAppender;
    private static TokenBucket exceptionBucket;
    private static final String configFileName = "arms-agent.config";
    public static final String AGENT_DIR_KEY = "agent_dir_key";
    static final long MAX_ARMS_LOG_FILE_SIZE;
    public static final String CLASS_LOCATION;
    private static boolean isInfoEnable;
    private static boolean isDebugEnable;
    private static boolean isWarnEnable;
    private static boolean isErrorEnable;
    private static boolean isTraceEnable;
    private static final String CAUSE_CAPTION = "Caused by: ";
    private static final String SUPPRESSED_CAPTION = "Suppressed: ";
    private static final int MAX_ENCLOSING_STACK_LEVEL = 5;
    public static final int MAX_BIZ_LOG_SIZE;

    public static boolean isInfoEnabled() {
        return isInfoEnable;
    }

    public static void info(String logContent) {
        if (isInfoEnable) {
            ArmsLogger.loggerContent(logContent, LogLevel.INFO);
        }
    }

    public static void info(String format, Object arg) {
        if (isInfoEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.INFO);
        }
    }

    public static void info(String format, Object arg1, Object arg2) {
        if (isInfoEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.INFO);
        }
    }

    public static void info(String format, Object ... arguments) {
        if (isInfoEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arguments);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.INFO);
        }
    }

    public static void info(String msg, Throwable t) {
        if (isInfoEnable) {
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + t.getMessage()), LogLevel.INFO);
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + ArmsLogger.printStack(t)), LogLevel.INFO);
        }
    }

    public static boolean isWarnEnabled() {
        return isWarnEnable;
    }

    public static void warn(String logContent) {
        if (isWarnEnable) {
            ArmsLogger.loggerContent(logContent, LogLevel.WARN);
        }
    }

    public static void warn(String format, Object arg) {
        if (isWarnEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.WARN);
        }
    }

    public static void warn(String format, Object arg1, Object arg2) {
        if (isWarnEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.WARN);
        }
    }

    public static void warn(String format, Object ... arguments) {
        if (isWarnEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arguments);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.WARN);
        }
    }

    public static void warn(String msg, Throwable t) {
        if (isWarnEnable) {
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + t.getMessage()), LogLevel.WARN);
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + ArmsLogger.printStack(t)), LogLevel.WARN);
        }
    }

    public static boolean isErrorEnabled() {
        return isErrorEnable;
    }

    public static void error(String logContent) {
        if (isErrorEnable) {
            ArmsLogger.loggerContent(logContent, LogLevel.ERROR);
        }
    }

    public static void error(String format, Object arg) {
        if (isErrorEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.ERROR);
        }
    }

    public static void error(String format, Object arg1, Object arg2) {
        if (isErrorEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.ERROR);
        }
    }

    public static void error(String format, Object ... arguments) {
        if (isErrorEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arguments);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.ERROR);
        }
    }

    public static void error(String msg, Throwable t) {
        if (isErrorEnable) {
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + t.getMessage()), LogLevel.ERROR);
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + ArmsLogger.printStack(t)), LogLevel.ERROR);
        }
    }

    public static boolean isDebugEnabled() {
        return isDebugEnable;
    }

    public static void debug(String logContent) {
        if (isDebugEnable) {
            ArmsLogger.loggerContent(logContent, LogLevel.DEBUG);
        }
    }

    public static void debug(String format, Object arg) {
        if (isDebugEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.DEBUG);
        }
    }

    public static void debug(String format, Object arg1, Object arg2) {
        if (isDebugEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.DEBUG);
        }
    }

    public static void debug(String format, Object ... arguments) {
        if (isDebugEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arguments);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.DEBUG);
        }
    }

    public static void debug(String msg, Throwable t) {
        if (isDebugEnable) {
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + t.getMessage()), LogLevel.DEBUG);
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + ArmsLogger.printStack(t)), LogLevel.DEBUG);
        }
    }

    public static boolean isTraceEnabled() {
        return isTraceEnable;
    }

    public static void trace(String logContent) {
        if (isTraceEnable) {
            ArmsLogger.loggerContent(logContent, LogLevel.TRACE);
        }
    }

    public static void trace(String format, Object arg) {
        if (isTraceEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.TRACE);
        }
    }

    public static void trace(String format, Object arg1, Object arg2) {
        if (isTraceEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.TRACE);
        }
    }

    public static void trace(String format, Object ... arguments) {
        if (isTraceEnable) {
            FormattingTuple ft = MessageFormatter.format(format, arguments);
            ArmsLogger.loggerContent(ft.getMessage(), LogLevel.TRACE);
        }
    }

    public static void trace(String msg, Throwable t) {
        if (isTraceEnable) {
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + t.getMessage()), LogLevel.TRACE);
            ArmsLogger.loggerContent(msg + (t == null ? "" : " " + ArmsLogger.printStack(t)), LogLevel.TRACE);
        }
    }

    private static void loggerContent(String logContent, LogLevel logLevel) {
        String traceId = "";
        String rpcId = "";
        BaseContext ctx = new BaseContext(traceId, rpcId);
        ctx.setLogLevel(logLevel);
        ctx.setLoggerType(LogType.LOGGER);
        ctx.callBackMsg = logContent;
        try {
            ctx.setThreadId(Thread.currentThread().getId());
            StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
            if (stackTraceElements.length >= 4) {
                ctx.setClazzName(stackTraceElements[4].getClassName());
                ctx.setMethodName(stackTraceElements[4].getMethodName());
            } else if (stackTraceElements.length >= 3) {
                ctx.setClazzName(stackTraceElements[3].getClassName());
                ctx.setMethodName(stackTraceElements[3].getMethodName());
            }
        }
        catch (Exception e) {
            ArmsLogger.selfLog("[ArmsLogger pointcut] [afterReturn] cant get ClassPath and MethodName. Exception: " + e);
        }
        ArmsLogger.logLine(ctx);
    }

    public static void logLine(String level, String traceId, String rpcId, String clazzName, String methodName, String LogType2, String logContent) {
        BaseContext ctx = new BaseContext(traceId, rpcId);
        ctx.setLogLevel(level);
        ctx.setLoggerType(LogType2);
        ctx.setClazzName(clazzName);
        ctx.setMethodName(methodName);
        ctx.callBackMsg = logContent;
        ArmsLogger.logLine(ctx);
    }

    private static void logLine(BaseContext biz) {
        String logContent = biz.callBackMsg;
        if (logContent == null) {
            ArmsLogger.selfLog("[WARN] ArmsLogger not logged for logContent is null");
            return;
        }
        if (biz.logTime <= 0L) {
            biz.logTime = System.currentTimeMillis();
        }
        if (logContent.length() > MAX_BIZ_LOG_SIZE) {
            bizAppender.append(biz);
            bizAppender.flush();
            return;
        }
        bizAppender.append(biz);
    }

    private static void printEnclosedStackTrace(Throwable throwable, StackTraceElement[] enclosingTrace, String caption, String prefix, Set<Throwable> dejaVu, StringBuilder sb, int currentLevel) {
        if (currentLevel > 5) {
            return;
        }
        if (dejaVu.contains(throwable)) {
            sb.append("\t[CIRCULAR REFERENCE:" + throwable + "]\n");
        } else {
            Throwable ourCause;
            dejaVu.add(throwable);
            StackTraceElement[] trace = throwable.getStackTrace();
            int m = trace.length - 1;
            for (int n = enclosingTrace.length - 1; m >= 0 && n >= 0 && trace[m].equals(enclosingTrace[n]); --m, --n) {
            }
            int framesInCommon = trace.length - 1 - m;
            sb.append(prefix + caption + throwable + "\n");
            for (int i = 0; i <= m; ++i) {
                sb.append(prefix + "\tat " + trace[i] + "\n");
            }
            if (framesInCommon != 0) {
                sb.append(prefix + "\t... " + framesInCommon + " more\n");
            }
            if ((ourCause = throwable.getCause()) != null) {
                ArmsLogger.printEnclosedStackTrace(ourCause, trace, CAUSE_CAPTION, prefix, dejaVu, sb, currentLevel + 1);
            }
        }
    }

    private static String printStack(Throwable throwable) {
        StackTraceElement[] trace = throwable.getStackTrace();
        Set<Throwable> dejaVu = Collections.newSetFromMap(new IdentityHashMap());
        dejaVu.add(throwable);
        StringBuilder sb = new StringBuilder();
        sb.append(throwable + "\n");
        for (StackTraceElement traceElement : trace) {
            sb.append("\tat " + traceElement);
            sb.append("\n");
        }
        Throwable ourCause = throwable.getCause();
        if (ourCause != null) {
            ArmsLogger.printEnclosedStackTrace(ourCause, trace, CAUSE_CAPTION, "", dejaVu, sb, 0);
        }
        return sb.toString();
    }

    private static void init() {
        if (initFlag.compareAndSet(false, true)) {
            try {
                bizAppender = new AsyncAppender((int)ArmsLoggerUtils.getPropertiesForLong("ARMS.LOG.BIZ.QUEUESIZE", 5120L), 0);
                RollingFileAppender armsLogger = new RollingFileAppender(ARMSLOGGER_LOG_FILE, ArmsLoggerUtils.getPropertiesForLong("ARMS.LOG.BIZ.FILESIZE", MAX_ARMS_LOG_FILE_SIZE), true);
                armsLogger.setMaxBackupIndex((int)ArmsLoggerUtils.getPropertiesForLong("ARMS.LOG.BIZ.BACKUPSIZE", 1L));
                bizAppender.start(armsLogger, new ArmsAgentLoggerEncoder(), "ArmsLoggerLog");
                LogDaemon.watch(bizAppender);
            }
            catch (Throwable e) {
                ArmsLogger.selfLog("[ERROR] fail to create ARMS Logger", e);
            }
            try {
                ArmsLogger.selfLog("[INFO] ARMS Logger started (" + CLASS_LOCATION + ")" + ", classloader=" + ArmsLogger.class.getClassLoader() + ", pid=" + ArmsLoggerUtils.getCurrrentPid());
            }
            catch (Throwable e) {
                ArmsLogger.selfLog("[INFO] ARMS Logger started (" + CLASS_LOCATION + "), pid=" + ArmsLoggerUtils.getCurrrentPid());
            }
            try {
                LogDaemon.start();
            }
            catch (Throwable e) {
                ArmsLogger.selfLog("[ERROR] fail to start LogDaemon", e);
            }
        }
    }

    private static String getLogLevel() {
        String Log_level = ArmsLoggerUtils.getProperties("profiler.agent.logger.level", "WARN");
        ArmsLogger.selfLog("[Arms Logger] log level: " + Log_level);
        return Log_level;
    }

    public static void reloadLogLevel(String level) {
        isInfoEnable = ArmsLogger.configLogLevel(LogLevel.INFO, level);
        isWarnEnable = ArmsLogger.configLogLevel(LogLevel.WARN, level);
        isDebugEnable = ArmsLogger.configLogLevel(LogLevel.DEBUG, level);
        isTraceEnable = ArmsLogger.configLogLevel(LogLevel.TRACE, level);
        isErrorEnable = ArmsLogger.configLogLevel(LogLevel.ERROR, level);
        ArmsLogger.loggerContent("[reload] info:" + isInfoEnable, LogLevel.WARN);
        ArmsLogger.loggerContent("[reload] warn:" + isWarnEnable, LogLevel.WARN);
        ArmsLogger.loggerContent("[reload] debug:" + isDebugEnable, LogLevel.WARN);
        ArmsLogger.loggerContent("[reload] trace:" + isTraceEnable, LogLevel.WARN);
        ArmsLogger.loggerContent("[reload] error:" + isErrorEnable, LogLevel.WARN);
    }

    private static final boolean configLogLevel(LogLevel logLevel) {
        return ArmsLogger.configLogLevel(logLevel, CONFIG_LOG_LEVEL);
    }

    private static final boolean configLogLevel(LogLevel logLevel, String currentLevel) {
        int CONFIG_LOG_LEVEL_INT = ArmsLogger.calLOGLEVEL(currentLevel);
        int cur_log_level_int = ArmsLogger.calLOGLEVEL(logLevel.valueOf());
        return cur_log_level_int <= CONFIG_LOG_LEVEL_INT;
    }

    private static int calLOGLEVEL(String config_log_level) {
        if (config_log_level == null) {
            return 1;
        }
        if (config_log_level.equals("ERROR") || config_log_level.equals("error")) {
            return 1;
        }
        if (config_log_level.equals("WARN") || config_log_level.equals("warn")) {
            return 2;
        }
        if (config_log_level.equals("INFO") || config_log_level.equals("info")) {
            return 3;
        }
        if (config_log_level.equals("DEBUG") || config_log_level.equals("debug")) {
            return 4;
        }
        if (config_log_level.equals("TRACE") || config_log_level.equals("trace")) {
            return 5;
        }
        return 1;
    }

    private static final String locateAgentDir() {
        String agentHome = ArmsApmConstants.agentDir;
        if (ArmsLoggerUtils.isNotBlank(agentHome)) {
            if (!agentHome.endsWith(File.separator)) {
                agentHome = agentHome + File.separator;
            }
        } else {
            agentHome = "/tmp/";
        }
        return agentHome;
    }

    private static final String locateUserHome() {
        String userHome = ArmsLoggerUtils.getSystemProperty("user.home");
        if (ArmsLoggerUtils.isNotBlank(userHome)) {
            if (!userHome.endsWith(File.separator)) {
                userHome = userHome + File.separator;
            }
        } else {
            userHome = "/tmp/";
        }
        return userHome;
    }

    private static final String locateBaseLogPath() {
        String tmpPath = ArmsLoggerUtils.getProperties("JM.LOG.PATH");
        if (ArmsLoggerUtils.isNotBlank(tmpPath)) {
            if (!tmpPath.endsWith(File.separator)) {
                tmpPath = tmpPath + File.separator;
            }
        } else {
            tmpPath = AGENT_HOME + "logs" + File.separator;
        }
        return tmpPath;
    }

    private static final String locateARMSLogDirPath() {
        String tmpPath = ArmsLoggerUtils.getProperties("ARMSLOGGER.LOG.DIRPATH");
        if (ArmsLoggerUtils.isNotBlank(tmpPath)) {
            File file = new File(tmpPath);
            if (file.isDirectory()) {
                return tmpPath;
            }
        } else {
            tmpPath = BASE_LOG_DIR + "arms_log" + File.separator;
        }
        return tmpPath;
    }

    private static final String locateARMSLogPath() {
        String tmpPath = ArmsLoggerUtils.getProperties("ARMSLOGGER.LOG.PATH");
        if (ArmsLoggerUtils.isNotBlank(tmpPath)) {
            return tmpPath;
        }
        tmpPath = BASE_LOG_DIR + ArmsApmConstants.appId + ".log";
        return tmpPath;
    }

    private static final String locateARMSSelfLogPath() {
        String tmpPath = ArmsLoggerUtils.getProperties("ARMSLOGGER.LOG.SELFPATH");
        if (ArmsLoggerUtils.isNotBlank(tmpPath)) {
            return tmpPath;
        }
        tmpPath = BASE_LOG_DIR + File.separator + "arms_log" + File.separator + "arms-logger-self.log";
        return tmpPath;
    }

    private static final long configLogFileSize() {
        long def = 0x6400000L;
        long fileSizeLong = ArmsLoggerUtils.getPropertiesForLong("ARMSLOGGER.LOG.FILESIZE", def);
        if (fileSizeLong > 0L) {
            return fileSizeLong;
        }
        return def;
    }

    private static final int configLogMaxBizSize() {
        int def = 4096;
        int fileSizeInt = ArmsLoggerUtils.getPropertiesForInteger("ARMSLOGGER.LOG.MAXBIZSIZE", def);
        if (fileSizeInt > 0) {
            return fileSizeInt;
        }
        return def;
    }

    static final Charset getDefaultOutputCharset() {
        Charset cs;
        String charsetName = ArmsLoggerUtils.getProperties("ARMSLOGGER.CHARSET");
        if (ArmsLoggerUtils.isNotBlank(charsetName)) {
            charsetName = charsetName.trim();
            try {
                cs = Charset.forName(charsetName);
                if (cs != null) {
                    return cs;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            cs = Charset.forName("UTF-8");
        }
        catch (Exception var5) {
            try {
                cs = Charset.forName("GBK");
            }
            catch (Exception var4) {
                cs = Charset.forName("GB18030");
            }
        }
        return cs;
    }

    private static final Appender createSelfLogger() {
        RollingFileAppender selfAppender = new RollingFileAppender(ARMSLOGGER_SELF_LOG_FILE, ArmsLoggerUtils.getPropertiesForLong("ARMS.LOG.SELF.FILESIZE", 0x6400000L), false);
        selfAppender.setMaxBackupIndex((int)ArmsLoggerUtils.getPropertiesForLong("ARMS.LOG.SELF.BACKUPSIZE", 1L));
        return new SyncAppender(selfAppender);
    }

    public static void selfLog(String log) {
        try {
            String timestamp = ArmsLoggerUtils.formatTime(System.currentTimeMillis());
            String line = "[" + timestamp + "] " + log + "\r\n";
            selfAppender.append(line);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void selfLog(String log, Throwable e) {
        long now = System.currentTimeMillis();
        if (exceptionBucket.acquire(now)) {
            try {
                String timestamp = ArmsLoggerUtils.formatTime(now);
                StringWriter sw = new StringWriter(4096);
                PrintWriter pw = new PrintWriter((Writer)sw, false);
                pw.append('[').append(timestamp).append("] ").append(log).append("\r\n");
                e.printStackTrace(pw);
                pw.println();
                pw.flush();
                selfAppender.append(sw.toString());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void flush() {
        bizAppender.flush();
        selfAppender.flush();
    }

    private static Properties readConfigProperties() {
        Properties properties = null;
        try {
            properties = new Properties();
            properties = PropertyUtils.loadProperty(AGENT_HOME + File.separator + configFileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    static {
        MAX_ARMS_LOG_FILE_SIZE = ArmsLogger.configLogFileSize();
        CLASS_LOCATION = ArmsLoggerUtils.getClassLocation(ArmsLogger.class);
        isInfoEnable = ArmsLogger.configLogLevel(LogLevel.INFO);
        isDebugEnable = ArmsLogger.configLogLevel(LogLevel.DEBUG);
        isWarnEnable = ArmsLogger.configLogLevel(LogLevel.WARN);
        isErrorEnable = ArmsLogger.configLogLevel(LogLevel.ERROR);
        isTraceEnable = ArmsLogger.configLogLevel(LogLevel.TRACE);
        MAX_BIZ_LOG_SIZE = ArmsLogger.configLogMaxBizSize();
        selfAppender = ArmsLogger.createSelfLogger();
        exceptionBucket = new TokenBucket(10L, TimeUnit.SECONDS.toMillis(10L));
        ArmsLogger.init();
    }
}

