/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import com.navercorp.pinpoint.common.arms.logger.Appender;
import com.navercorp.pinpoint.common.arms.logger.ArmsLoggerDispatch;
import com.navercorp.pinpoint.common.arms.logger.AsyncAppender;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class LogDaemon
implements Runnable {
    private static final long LOG_CHECK_INTERVAL = TimeUnit.SECONDS.toMillis(10L);
    private static final long INDEX_FLUSH_INTERVAL = TimeUnit.HOURS.toMillis(12L);
    private static long nextIndexFlushTime = System.currentTimeMillis() + INDEX_FLUSH_INTERVAL;
    private static AtomicBoolean running = new AtomicBoolean(false);
    private static Thread worker = null;
    private static final CopyOnWriteArrayList<Appender> watchedAppenders = new CopyOnWriteArrayList();

    static final Appender watch(Appender appender) {
        watchedAppenders.addIfAbsent(appender);
        return appender;
    }

    static final boolean unwatch(Appender appender) {
        return watchedAppenders.remove(appender);
    }

    @Override
    public void run() {
        while (running.get()) {
            this.cleanupFiles();
            try {
                Thread.sleep(LOG_CHECK_INTERVAL);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flushAndReload();
        }
    }

    private void cleanupFiles() {
        for (Appender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.cleanup();
            }
            catch (Exception e) {
                ArmsLoggerDispatch.selfLog("[ERROR] fail to cleanup: " + watchedAppender, e);
            }
        }
        try {
            ArmsLoggerDispatch.selfAppender.cleanup();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void flushAndReload() {
        for (Appender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.reload();
            }
            catch (Exception e) {
                ArmsLoggerDispatch.selfLog("[ERROR] fail to reload: " + watchedAppender, e);
            }
        }
        try {
            ArmsLoggerDispatch.selfAppender.reload();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void start() {
        if (running.compareAndSet(false, true)) {
            Thread worker = new Thread(new LogDaemon());
            worker.setDaemon(true);
            worker.setName("ArmsLogger-LogDaemon-Thread");
            worker.start();
            LogDaemon.worker = worker;
        }
    }

    static void stop() {
        if (running.compareAndSet(true, false)) {
            LogDaemon.closeAppenders();
            Thread worker = LogDaemon.worker;
            if (worker != null) {
                try {
                    worker.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    worker.join(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void closeAppenders() {
        for (Appender watchedAppender : watchedAppenders) {
            try {
                watchedAppender.close();
            }
            catch (Exception e) {
                ArmsLoggerDispatch.selfLog("[ERROR] fail to close: " + watchedAppender, e);
            }
        }
    }

    static void flushAndWait() {
        for (Appender watchedAppender : watchedAppenders) {
            try {
                if (watchedAppender instanceof AsyncAppender) {
                    ((AsyncAppender)watchedAppender).flushAndWait();
                    continue;
                }
                watchedAppender.flush();
            }
            catch (Exception e) {
                ArmsLoggerDispatch.selfLog("[ERROR] fail to flush: " + watchedAppender, e);
            }
        }
    }

    private LogDaemon() {
    }
}

