/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logger;

import java.util.concurrent.atomic.AtomicLong;

public class TokenBucket {
    private final long maxTokens;
    private final long intervalMillis;
    private volatile long nextUpdate;
    private AtomicLong tokens;

    public TokenBucket(long maxTokens, long intervalMillis) {
        if (maxTokens <= 0L) {
            throw new IllegalArgumentException("maxTokens \u9700\u8981\u5927\u4e8e 0: " + maxTokens);
        }
        if (intervalMillis < 1000L) {
            throw new IllegalArgumentException("intervalMillis \u9700\u8981\u5927\u4e8e\u7b49\u4e8e 1000 \u6beb\u79d2: " + intervalMillis);
        }
        this.maxTokens = maxTokens;
        this.intervalMillis = intervalMillis;
        this.nextUpdate = System.currentTimeMillis() / 1000L * 1000L + intervalMillis;
        this.tokens = new AtomicLong(maxTokens);
    }

    public boolean acquire(long now) {
        long currTokens;
        if (now > this.nextUpdate && this.tokens.compareAndSet(currTokens = this.tokens.get(), this.maxTokens)) {
            this.nextUpdate = System.currentTimeMillis() / 1000L * 1000L + this.intervalMillis;
        }
        while ((currTokens = this.tokens.get()) > 0L && !this.tokens.compareAndSet(currTokens, currTokens - 1L)) {
        }
        return currTokens > 0L;
    }
}

