/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logging;

import com.navercorp.pinpoint.common.arms.logger.ArmsLogger;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;
import java.util.Map;

public class ArmsLoggerAdapter
implements PLogger {
    public static final int BUFFER_SIZE = 512;
    private static final Map<Class<?>, Class<?>> SIMPLE_TYPE = new IdentityHashMap();

    public String getName() {
        return "ArmsLogger";
    }

    @Override
    public void beforeInterceptor(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("BEFORE ");
        ArmsLoggerAdapter.logMethod(sb, target, className, methodName, parameterDescription, args);
        ArmsLogger.debug(sb.toString());
    }

    @Override
    public void beforeInterceptor(Object target, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("BEFORE ");
        ArmsLoggerAdapter.logMethod(sb, target, args);
        ArmsLogger.debug(sb.toString());
    }

    @Override
    public void afterInterceptor(Object target, String className, String methodName, String parameterDescription, Object[] args, Object result, Throwable throwable) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        ArmsLoggerAdapter.logMethod(sb, target, className, methodName, parameterDescription, args);
        ArmsLoggerAdapter.logResult(sb, result, throwable);
        if (throwable == null) {
            ArmsLogger.debug(sb.toString());
        } else {
            ArmsLogger.debug(sb.toString(), throwable);
        }
    }

    @Override
    public void afterInterceptor(Object target, Object[] args, Object result, Throwable throwable) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        ArmsLoggerAdapter.logMethod(sb, target, args);
        ArmsLoggerAdapter.logResult(sb, result, throwable);
        if (throwable == null) {
            ArmsLogger.debug(sb.toString());
        } else {
            ArmsLogger.debug(sb.toString(), throwable);
        }
    }

    private static void logResult(StringBuilder sb, Object result, Throwable throwable) {
        if (throwable == null) {
            sb.append(" result:");
            sb.append(ArmsLoggerAdapter.normalizedParameter(result));
        } else {
            sb.append(" Caused:");
            sb.append(throwable.getMessage());
        }
    }

    @Override
    public void afterInterceptor(Object target, String className, String methodName, String parameterDescription, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        ArmsLoggerAdapter.logMethod(sb, target, className, methodName, parameterDescription, args);
        ArmsLogger.debug(sb.toString());
    }

    @Override
    public void afterInterceptor(Object target, Object[] args) {
        StringBuilder sb = new StringBuilder(512);
        sb.append("AFTER ");
        ArmsLoggerAdapter.logMethod(sb, target, args);
        ArmsLogger.debug(sb.toString());
    }

    private static void logMethod(StringBuilder sb, Object target, String className, String methodName, String parameterDescription, Object[] args) {
        sb.append(ArmsLoggerAdapter.getTarget(target));
        sb.append(' ');
        sb.append(className);
        sb.append(' ');
        sb.append(methodName);
        sb.append(parameterDescription);
        sb.append(" args:");
        ArmsLoggerAdapter.appendParameterList(sb, args);
    }

    private static void logMethod(StringBuilder sb, Object target, Object[] args) {
        sb.append(ArmsLoggerAdapter.getTarget(target));
        sb.append(' ');
        sb.append(" args:");
        ArmsLoggerAdapter.appendParameterList(sb, args);
    }

    private static String getTarget(Object target) {
        if (target == null) {
            return "target=null";
        }
        return target.getClass().getName();
    }

    private static void appendParameterList(StringBuilder sb, Object[] args) {
        if (args == null || args.length == 0) {
            sb.append("()");
            return;
        }
        if (args.length > 0) {
            sb.append('(');
            sb.append(ArmsLoggerAdapter.normalizedParameter(args[0]));
            for (int i = 1; i < args.length; ++i) {
                sb.append(", ");
                sb.append(ArmsLoggerAdapter.normalizedParameter(args[i]));
            }
            sb.append(')');
        }
    }

    private static String normalizedParameter(Object arg) {
        if (arg == null) {
            return "null";
        }
        if (ArmsLoggerAdapter.isSimpleType(arg)) {
            return arg.toString();
        }
        return arg.getClass().getSimpleName();
    }

    private static boolean isSimpleType(Object arg) {
        Class<?> find = SIMPLE_TYPE.get(arg.getClass());
        return find != null;
    }

    @Override
    public boolean isTraceEnabled() {
        return ArmsLogger.isTraceEnabled();
    }

    @Override
    public void trace(String msg) {
        ArmsLogger.trace(msg);
    }

    @Override
    public void trace(String format, Object arg) {
        ArmsLogger.trace(format, arg);
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        ArmsLogger.trace(format, arg1, arg2);
    }

    @Override
    public void trace(String format, Object[] argArray) {
        ArmsLogger.trace(format, argArray);
    }

    @Override
    public void trace(String msg, Throwable t) {
        ArmsLogger.trace(msg, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return ArmsLogger.isDebugEnabled();
    }

    @Override
    public void debug(String msg) {
        ArmsLogger.debug(msg);
    }

    @Override
    public void debug(String format, Object arg) {
        ArmsLogger.debug(format, arg);
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        ArmsLogger.debug(format, arg1, arg2);
    }

    @Override
    public void debug(String format, Object[] argArray) {
        ArmsLogger.debug(format, argArray);
    }

    @Override
    public void debug(String msg, Throwable t) {
        ArmsLogger.debug(msg, t);
    }

    @Override
    public boolean isInfoEnabled() {
        return ArmsLogger.isInfoEnabled();
    }

    @Override
    public void info(String msg) {
        ArmsLogger.info(msg);
    }

    @Override
    public void info(String format, Object arg) {
        ArmsLogger.info(format, arg);
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        ArmsLogger.info(format, arg1, arg2);
    }

    @Override
    public void info(String format, Object[] argArray) {
        ArmsLogger.info(format, argArray);
    }

    @Override
    public void info(String msg, Throwable t) {
        ArmsLogger.info(msg, t);
    }

    @Override
    public boolean isWarnEnabled() {
        return ArmsLogger.isWarnEnabled();
    }

    @Override
    public void warn(String msg) {
        ArmsLogger.warn(msg);
    }

    @Override
    public void warn(String format, Object arg) {
        ArmsLogger.warn(format, arg);
    }

    @Override
    public void warn(String format, Object[] argArray) {
        ArmsLogger.warn(format, argArray);
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        ArmsLogger.warn(format, arg1, arg2);
    }

    @Override
    public void warn(String msg, Throwable t) {
        ArmsLogger.warn(msg, t);
    }

    @Override
    public boolean isErrorEnabled() {
        return ArmsLogger.isErrorEnabled();
    }

    @Override
    public void error(String msg) {
        ArmsLogger.error(msg);
    }

    @Override
    public void error(String format, Object arg) {
        ArmsLogger.error(format, arg);
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        ArmsLogger.error(format, arg1, arg2);
    }

    @Override
    public void error(String format, Object[] argArray) {
        ArmsLogger.error(format, argArray);
    }

    @Override
    public void error(String msg, Throwable t) {
        ArmsLogger.error(msg, t);
    }

    static {
        SIMPLE_TYPE.put(String.class, String.class);
        SIMPLE_TYPE.put(Boolean.class, Boolean.class);
        SIMPLE_TYPE.put(Boolean.TYPE, Boolean.TYPE);
        SIMPLE_TYPE.put(Byte.class, Byte.class);
        SIMPLE_TYPE.put(Byte.TYPE, Byte.TYPE);
        SIMPLE_TYPE.put(Short.class, Short.class);
        SIMPLE_TYPE.put(Short.TYPE, Short.TYPE);
        SIMPLE_TYPE.put(Integer.class, Integer.class);
        SIMPLE_TYPE.put(Integer.TYPE, Integer.TYPE);
        SIMPLE_TYPE.put(Long.class, Long.class);
        SIMPLE_TYPE.put(Long.TYPE, Long.TYPE);
        SIMPLE_TYPE.put(Float.class, Float.class);
        SIMPLE_TYPE.put(Float.TYPE, Float.TYPE);
        SIMPLE_TYPE.put(Double.class, Double.class);
        SIMPLE_TYPE.put(Double.TYPE, Double.TYPE);
        SIMPLE_TYPE.put(Character.class, Character.class);
        SIMPLE_TYPE.put(Character.TYPE, Character.TYPE);
        SIMPLE_TYPE.put(BigDecimal.class, BigDecimal.class);
        SIMPLE_TYPE.put(StringBuffer.class, StringBuffer.class);
        SIMPLE_TYPE.put(BigInteger.class, BigInteger.class);
        SIMPLE_TYPE.put(Class.class, Class.class);
        SIMPLE_TYPE.put(Date.class, Date.class);
        SIMPLE_TYPE.put(java.util.Date.class, java.util.Date.class);
        SIMPLE_TYPE.put(Time.class, Time.class);
        SIMPLE_TYPE.put(Timestamp.class, Timestamp.class);
        SIMPLE_TYPE.put(Calendar.class, Calendar.class);
        SIMPLE_TYPE.put(GregorianCalendar.class, GregorianCalendar.class);
        SIMPLE_TYPE.put(URL.class, URL.class);
        SIMPLE_TYPE.put(Object.class, Object.class);
    }
}

