/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.logging;

import com.navercorp.pinpoint.common.arms.logging.ArmsLoggerBinder;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerBinder;

public final class PLoggerFactory {
    private static PLoggerBinder loggerBinder;

    public static void initialize(PLoggerBinder loggerBinder) {
        if (PLoggerFactory.loggerBinder == null) {
            PLoggerFactory.loggerBinder = loggerBinder;
        }
    }

    public static void unregister(PLoggerBinder loggerBinder) {
        if (loggerBinder == PLoggerFactory.loggerBinder) {
            PLoggerFactory.loggerBinder = null;
        }
    }

    public static PLogger getLogger(String name) {
        if (loggerBinder == null) {
            ArmsLoggerBinder binder = new ArmsLoggerBinder();
            String binderClassName = binder.getClass().getName();
            PLogger pLogger = binder.getLogger(binder.getClass().getName());
            pLogger.info("PLoggerFactory init PLoggerFactory.initialize() bind:{} cl:{}", (Object)binderClassName, (Object)binder.getClass().getClassLoader());
            PLoggerFactory.initialize(binder);
            return binder.getLogger(name);
        }
        return loggerBinder.getLogger(name);
    }

    public static PLogger getLogger(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("class must not be null");
        }
        return PLoggerFactory.getLogger(clazz.getName());
    }
}

