/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;

public final class CommonUtils {
    public static String byteArrayToHex(byte[] bs, int start, int end) {
        StringBuilder sb = new StringBuilder(bs.length << 1);
        for (int i = start; i < end; ++i) {
            byte b = bs[i];
            sb.append("0123456789abcdef".charAt(0xF & b >> 4));
            sb.append("0123456789abcdef".charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static String byteArrayToHex(byte[] bs) {
        return CommonUtils.byteArrayToHex(bs, 0, bs.length);
    }

    public static byte[] hexToByteArray(String hex) {
        byte[] bs = new byte[hex.length() / 2];
        for (int i = 0; i < bs.length; ++i) {
            bs[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return bs;
    }

    public static String md5(InputStream in) throws IOException {
        int bytes;
        MessageDigest md5;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Fail to get MD5 MessageDigest instance", e);
        }
        byte[] buffer = new byte[16384];
        while ((bytes = in.read(buffer)) != -1) {
            md5.update(buffer, 0, bytes);
        }
        byte[] bs = md5.digest();
        return CommonUtils.byteArrayToHex(bs);
    }

    public static String getMD5String(String str, String charset) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(str.getBytes(charset));
            byte[] byteArray = messageDigest.digest();
            StringBuffer md5StrBuff = new StringBuffer();
            for (int i = 0; i < byteArray.length; ++i) {
                if (Integer.toHexString(0xFF & byteArray[i]).length() == 1) {
                    md5StrBuff.append("0").append(Integer.toHexString(0xFF & byteArray[i]));
                    continue;
                }
                md5StrBuff.append(Integer.toHexString(0xFF & byteArray[i]));
            }
            return md5StrBuff.toString().toLowerCase();
        }
        catch (NoSuchAlgorithmException e) {
            return str;
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String crc(byte[] bytes) {
        CRC32 c = new CRC32();
        c.update(bytes);
        return Long.toHexString(c.getValue());
    }

    public static int crcToInt(byte[] bytes) {
        CRC32 c = new CRC32();
        c.update(bytes);
        return (int)c.getValue();
    }

    public static <K, V> List<V> addToMultiMap(Map<K, List<V>> multiMap, K key, V value) {
        List<V> values = multiMap.get(key);
        if (values == null) {
            values = new ArrayList<V>();
            multiMap.put(key, values);
        }
        values.add(value);
        return values;
    }

    public static <T> List<T> subList(List<T> list, int offset, int maxSize) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return list;
        }
        if (offset >= 0 && offset < list.size()) {
            return list.subList(offset, Math.min(offset + maxSize, list.size()));
        }
        return list.subList(0, 0);
    }

    public static <T> Map<T, Integer> cardinalityMap(Collection<T> list) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        for (T item : list) {
            Integer count = (Integer)map.get(item);
            if (count != null) {
                map.put(item, count + 1);
                continue;
            }
            map.put(item, 1);
        }
        return map;
    }

    public static <T> List<T> reverseCopy(Collection<T> c) {
        if (c == null) {
            return null;
        }
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.reverse(list);
        return list;
    }

    public static <T> T elementOf(Collection<? super T> c, int index) {
        if (CommonUtils.isNullEmpty(c) || index > c.size()) {
            return null;
        }
        if (c instanceof List) {
            return (T)((List)c).get(index);
        }
        int i = 0;
        Iterator<T> iterator = c.iterator();
        while (i++ < index) {
            iterator.next();
        }
        return iterator.next();
    }

    public static String[] array(String ... strs) {
        return strs;
    }

    public static long[] array(long ... values) {
        return values;
    }

    public static Object[] array(Object ... args) {
        return args;
    }

    public static long[] array(Collection<Long> values) {
        long[] array = new long[values.size()];
        int i = 0;
        for (Long value : values) {
            array[i++] = value;
        }
        return array;
    }

    public static long[] array(Long[] values) {
        long[] array = new long[values.length];
        int i = 0;
        for (Long value : values) {
            array[i++] = value;
        }
        return array;
    }

    public static Map<Object, Object> map(Object ... elements) {
        if (elements.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        Object k = null;
        for (int i = 0; i < elements.length; ++i) {
            if (i % 2 == 0) {
                k = elements[i];
                continue;
            }
            ret.put(k, elements[i]);
        }
        return ret;
    }

    public static boolean isNullEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isNullEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static boolean isNullEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static boolean isNullBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static String trimToNull(String str) {
        if (str == null) {
            return null;
        }
        String result = str.trim();
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public static String trimToEmpty(String str) {
        return str == null ? "" : str.trim();
    }

    public static String[] trimToEmpty(String[] strArray) {
        if (CommonUtils.isNullEmpty(strArray)) {
            return strArray;
        }
        for (int i = 0; i < strArray.length; ++i) {
            strArray[i] = CommonUtils.trimToEmpty(strArray[i]);
        }
        return strArray;
    }

    public static <T> T defaultIfNull(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static String defaultIfEmpty(String str, String defaultValue) {
        return CommonUtils.isNullEmpty(str) ? defaultValue : str;
    }

    public static <T extends Collection<?>> T defaultIfEmpty(T c, T defaultValue) {
        return CommonUtils.isNullEmpty(c) ? defaultValue : c;
    }

    public static <T extends Map<?, ?>> T defaultIfEmpty(T m, T defaultValue) {
        return CommonUtils.isNullEmpty(m) ? defaultValue : m;
    }

    public static double divide(double dividend, double divisor) {
        return divisor != 0.0 ? dividend / divisor : 0.0;
    }

    public static long divideL(double dividend, double divisor) {
        return Math.round(CommonUtils.divide(dividend, divisor));
    }

    public static double percent(double dividend, double divisor) {
        return divisor != 0.0 ? dividend / divisor * 100.0 : 0.0;
    }

    public static int countMatches(String str, int ch) {
        if (CommonUtils.isNullEmpty(str)) {
            return 0;
        }
        int count = 0;
        int idx = 0;
        while ((idx = str.indexOf(ch, idx)) != -1) {
            ++count;
            ++idx;
        }
        return count;
    }

    public static Integer parseIntegerQuietly(String value) {
        int digit;
        int index;
        if (CommonUtils.isNullEmpty(value)) {
            return null;
        }
        boolean negative = value.charAt(0) == '-';
        int n = index = negative ? 1 : 0;
        if (index == value.length()) {
            return null;
        }
        if ((digit = value.charAt(index++) - 48) < 0 || digit > 9) {
            return null;
        }
        int accum = -digit;
        while (index < value.length()) {
            if ((digit = value.charAt(index++) - 48) < 0 || digit > 9 || accum < -214748364) {
                return null;
            }
            if ((accum *= 10) < Integer.MIN_VALUE + digit) {
                return null;
            }
            accum -= digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Integer.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    public static int parseIntQuietly(String value, int defaultValue, int beginPos, int endPos) {
        int digit;
        int index;
        if (value == null || beginPos < 0 || beginPos >= endPos || endPos > value.length()) {
            return defaultValue;
        }
        boolean negative = value.charAt(beginPos) == '-';
        int n = index = negative ? beginPos + 1 : beginPos;
        if (index == endPos) {
            return defaultValue;
        }
        if ((digit = value.charAt(index++) - 48) < 0 || digit > 9) {
            return defaultValue;
        }
        int accum = -digit;
        while (index < endPos) {
            if ((digit = value.charAt(index++) - 48) < 0 || digit > 9 || accum < -214748364) {
                return defaultValue;
            }
            if ((accum *= 10) < Integer.MIN_VALUE + digit) {
                return defaultValue;
            }
            accum -= digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Integer.MIN_VALUE) {
            return defaultValue;
        }
        return -accum;
    }

    public static int parseIntQuietly(String value, int defaultValue) {
        return value == null ? defaultValue : CommonUtils.parseIntQuietly(value, defaultValue, 0, value.length());
    }

    public static int parseIntQuietly(Object value, int defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return CommonUtils.parseIntQuietly(value.toString(), defaultValue);
    }

    public static <E extends Enum<E>> E parseEnumFromInteger(Integer value, Class<E> enumClass) {
        if (value != null) {
            Enum[] values = (Enum[])enumClass.getEnumConstants();
            int intValue = value;
            for (int i = 0; i < values.length; ++i) {
                if (values[i].ordinal() != intValue) continue;
                return (E)values[i];
            }
        }
        return null;
    }

    public static <E extends Enum<E>> E parseEnumFromInt(int idx, E defaultValue) {
        Enum[] values = (Enum[])defaultValue.getClass().getEnumConstants();
        if (idx >= 0 && idx < values.length) {
            if (values[idx].ordinal() == idx) {
                return (E)values[idx];
            }
            for (int i = 0; i < values.length; ++i) {
                if (values[i].ordinal() != idx) continue;
                return (E)values[i];
            }
        }
        return defaultValue;
    }

    public static <E extends Enum<E>> E parseEnumFromString(String value, Class<E> enumClass) {
        if (!CommonUtils.isNullEmpty(value)) {
            try {
                return Enum.valueOf(enumClass, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Long parseLongQuietly(String value) {
        int digit;
        int index;
        if (CommonUtils.isNullEmpty(value)) {
            return null;
        }
        boolean negative = value.charAt(0) == '-';
        int n = index = negative ? 1 : 0;
        if (index == value.length()) {
            return null;
        }
        if ((digit = value.charAt(index++) - 48) < 0 || digit > 9) {
            return null;
        }
        long accum = -digit;
        while (index < value.length()) {
            if ((digit = value.charAt(index++) - 48) < 0 || digit > 9 || accum < -922337203685477580L) {
                return null;
            }
            if ((accum *= 10L) < Long.MIN_VALUE + (long)digit) {
                return null;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return null;
        }
        return -accum;
    }

    public static long parseLongQuietly(String value, long defaultValue, int beginPos, int endPos) {
        int digit;
        int index;
        if (value == null || beginPos < 0 || beginPos >= endPos || endPos > value.length()) {
            return defaultValue;
        }
        boolean negative = value.charAt(beginPos) == '-';
        int n = index = negative ? beginPos + 1 : beginPos;
        if (index == endPos) {
            return defaultValue;
        }
        if ((digit = value.charAt(index++) - 48) < 0 || digit > 9) {
            return defaultValue;
        }
        long accum = -digit;
        while (index < endPos) {
            if ((digit = value.charAt(index++) - 48) < 0 || digit > 9 || accum < -922337203685477580L) {
                return defaultValue;
            }
            if ((accum *= 10L) < Long.MIN_VALUE + (long)digit) {
                return defaultValue;
            }
            accum -= (long)digit;
        }
        if (negative) {
            return accum;
        }
        if (accum == Long.MIN_VALUE) {
            return defaultValue;
        }
        return -accum;
    }

    public static long parseLongQuietly(String value, long defaultValue) {
        return value == null ? defaultValue : CommonUtils.parseLongQuietly(value, defaultValue, 0, value.length());
    }

    public static long parseLongQuietly(Object value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        return CommonUtils.parseLongQuietly(value.toString(), defaultValue);
    }

    public static Double parseDoubleQuietly(String value) {
        if (CommonUtils.isNullEmpty(value)) {
            return null;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static double parseDoubleQuietly(String value, double defaultValue) {
        if (CommonUtils.isNullEmpty(value)) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static double parseDoubleQuietly(Object value, double defaultValue) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return value == null ? defaultValue : CommonUtils.parseDoubleQuietly(value.toString(), defaultValue);
    }

    public static Boolean parseBooleanQuietly(String value) {
        if (CommonUtils.isNullEmpty(value)) {
            return null;
        }
        if ("true".equalsIgnoreCase(value)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(value)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public static boolean parseBooleanQuietly(String value, boolean defaultValue) {
        if (defaultValue) {
            return !"false".equalsIgnoreCase(value);
        }
        return "true".equalsIgnoreCase(value);
    }

    public static boolean parseBooleanQuietly(Object value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (defaultValue) {
            return !"false".equalsIgnoreCase(value.toString());
        }
        return "true".equalsIgnoreCase(value.toString());
    }

    public static String checkNotNullEmpty(String value, String name) throws IllegalArgumentException {
        if (CommonUtils.isNullEmpty(value)) {
            throw new IllegalArgumentException(name + "\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return value;
    }

    public static <T> T checkNotNull(T value, String name) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(name + " \u4e0d\u80fd\u4e3a\u7a7a");
        }
        return value;
    }

    public static int checkAndParseInt(String value, String name) throws IllegalArgumentException {
        try {
            return Integer.parseInt(CommonUtils.checkNotNull(CommonUtils.trimToNull(value), name));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " \u4e0d\u662f\u5408\u6cd5\u7684\u6574\u6570");
        }
    }

    public static long checkAndParseLong(String value, String name) throws IllegalArgumentException {
        try {
            return Long.parseLong(CommonUtils.checkNotNull(CommonUtils.trimToNull(value), name));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " \u4e0d\u662f\u5408\u6cd5\u7684\u6574\u6570");
        }
    }

    public static double checkAndParseDouble(String value, String name) throws IllegalArgumentException {
        try {
            return Double.parseDouble(CommonUtils.checkNotNull(CommonUtils.trimToNull(value), name));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(name + " \u4e0d\u662f\u5408\u6cd5\u7684\u6570\u503c");
        }
    }

    public static boolean isHexNumeric(char ch) {
        return ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f' || ch >= '0' && ch <= '9';
    }

    public static boolean isNumeric(char ch) {
        return ch >= '0' && ch <= '9';
    }

    public static int getLastNonDigitCharacterIndex(String string, int begin) {
        int len = string.length();
        for (int i = len - 1; i >= begin; --i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return i;
        }
        return -1;
    }

    public static int[] convertIntegerArray(Integer[] integers) {
        int[] ints = new int[integers.length];
        int i = 0;
        for (Integer integer : integers) {
            ints[i++] = integer;
        }
        return ints;
    }

    public static int[] convertIntegerArray(List<Integer> integers) {
        int[] ints = new int[integers.size()];
        for (int i = 0; i < integers.size(); ++i) {
            ints[i] = integers.get(i);
        }
        return ints;
    }

    public static int getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        return CommonUtils.parseIntQuietly(name.substring(0, name.indexOf(64)), 0);
    }

    public static long getGreatestCommonDivisor(long x, long y) {
        while (y != 0L) {
            long temp = y;
            y = x % y;
            x = temp;
        }
        return x;
    }

    public static long getLeastCommonMultiple(long x, long y) {
        return x / CommonUtils.getGreatestCommonDivisor(x, y) * y;
    }

    public static Map<String, String> getMapFromString(String feature) {
        String[] features;
        HashMap<String, String> featureMap = new HashMap<String, String>();
        if (feature != null && feature.length() > 0 && (features = feature.split(";")).length > 0) {
            for (String f : features) {
                String[] vals = f.split("=");
                if (vals.length <= 1) continue;
                featureMap.put(vals[0].trim(), f.substring(f.indexOf("=") + 1));
            }
        }
        return featureMap;
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }
}

