/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.arms.util;

import com.navercorp.pinpoint.common.arms.util.StringInfo;
import com.navercorp.pinpoint.common.arms.util.StringPattern;
import com.navercorp.pinpoint.common.arms.util.Term;
import com.navercorp.pinpoint.common.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConvergenceV4 {
    private static final int CLEAN_DIVISOR = 10;
    private static final int MIN_PATTERN_COUNT = 1;
    private static final int MIN_TERM_COUNT = 1;
    private final Set<Character> splitterSet = new HashSet<Character>(){
        {
            this.add(Character.valueOf('/'));
            this.add(Character.valueOf('-'));
            this.add(Character.valueOf('_'));
            this.add(Character.valueOf('='));
            this.add(Character.valueOf('-'));
            this.add(Character.valueOf('.'));
            this.add(Character.valueOf(','));
            this.add(Character.valueOf(':'));
            this.add(Character.valueOf(';'));
            this.add(Character.valueOf('?'));
            this.add(Character.valueOf('&'));
            this.add(Character.valueOf('$'));
            this.add(Character.valueOf('#'));
        }
    };
    private volatile int patternSizeLevelOne = 10;
    private volatile int patternSizeLevelTwo = 100;
    private volatile boolean ignoreNumber = true;
    private volatile boolean mergeStar = true;
    private volatile int maxPatternSize = 1024;
    private volatile int maxTermSize = 256;
    private volatile int cleaningCount = 10000;
    private volatile String variable = "*";
    private AtomicBoolean isCleaning = new AtomicBoolean(false);
    private AtomicInteger counter = new AtomicInteger(0);
    private volatile boolean needAutoConvergence = false;
    private volatile int minServerSizeForAutoConvergence = 1000;
    private CopyOnWriteArraySet<String> serviceSet = new CopyOnWriteArraySet();
    private CopyOnWriteArrayList<Pattern> patternList = new CopyOnWriteArrayList();
    private ConcurrentHashMap<String, StringPattern> stringPatternMapping = new ConcurrentHashMap(this.maxPatternSize * 2);

    public CopyOnWriteArrayList<Pattern> getPatternList() {
        return this.patternList;
    }

    public ConvergenceV4 setPatternList(CopyOnWriteArrayList<Pattern> patternList) {
        this.patternList = patternList;
        return this;
    }

    public int getMinServerSizeForAutoConvergence() {
        return this.minServerSizeForAutoConvergence;
    }

    public ConvergenceV4 setMinServerSizeForAutoConvergence(int minServerSizeForAutoConvergence) {
        this.minServerSizeForAutoConvergence = minServerSizeForAutoConvergence;
        return this;
    }

    public int getPatternSizeLevelOne() {
        return this.patternSizeLevelOne;
    }

    public ConvergenceV4 setPatternSizeLevelOne(int patternSizeLevelOne) {
        this.patternSizeLevelOne = patternSizeLevelOne;
        return this;
    }

    public int getPatternSizeLevelTwo() {
        return this.patternSizeLevelTwo;
    }

    public ConvergenceV4 setPatternSizeLevelTwo(int patternSizeLevelTwo) {
        this.patternSizeLevelTwo = patternSizeLevelTwo;
        return this;
    }

    public boolean isIgnoreNumber() {
        return this.ignoreNumber;
    }

    public ConvergenceV4 setIgnoreNumber(boolean ignoreNumber) {
        this.ignoreNumber = ignoreNumber;
        return this;
    }

    public boolean isMergeStar() {
        return this.mergeStar;
    }

    public ConvergenceV4 setMergeStar(boolean mergeStar) {
        this.mergeStar = mergeStar;
        return this;
    }

    public int getMaxPatternSize() {
        return this.maxPatternSize;
    }

    public ConvergenceV4 setMaxPatternSize(int maxPatternSize) {
        this.maxPatternSize = maxPatternSize;
        return this;
    }

    public int getMaxTermSize() {
        return this.maxTermSize;
    }

    public ConvergenceV4 setMaxTermSize(int maxTermSize) {
        this.maxTermSize = maxTermSize;
        return this;
    }

    public int getCleaningCount() {
        return this.cleaningCount;
    }

    public ConvergenceV4 setCleaningCount(int cleaningCount) {
        this.cleaningCount = cleaningCount;
        return this;
    }

    public String getVariable() {
        return this.variable;
    }

    public ConvergenceV4 setVariable(String variable) {
        this.variable = variable;
        return this;
    }

    public String convergence(String string, boolean enable) {
        if (enable) {
            return this.convergence(string, 1);
        }
        return string;
    }

    public String convergence(String string) {
        return this.convergence(string, 1);
    }

    public String convergence(String string, int count) {
        if (StringUtils.isEmpty(string)) {
            return string;
        }
        String ret = this.matchManualPattern(string);
        if (ret != null) {
            return ret;
        }
        if (!this.needAutoConvergence) {
            this.updateServiceSetAndAutoConvergenceFlag(string);
            return string;
        }
        return this.autoConvergence(string, count);
    }

    private String matchManualPattern(String string) {
        if (this.patternList == null) {
            return null;
        }
        for (Pattern pattern : this.patternList) {
            Matcher matcher = pattern.matcher(string);
            if (!matcher.matches()) continue;
            int gCount = matcher.groupCount();
            for (int i = 1; i <= gCount; ++i) {
                String g = matcher.group(i);
                if (g == null || g.length() <= 0) continue;
                string = string.replaceFirst(g, this.variable);
            }
            return string;
        }
        return null;
    }

    private void updateServiceSetAndAutoConvergenceFlag(String string) {
        this.serviceSet.add(string);
        if (this.serviceSet.size() > this.minServerSizeForAutoConvergence) {
            this.needAutoConvergence = true;
            this.serviceSet.clear();
        }
    }

    private String autoConvergence(String string, int count) {
        this.updateCounterAndCleanUp();
        StringInfo stringInfo = this.split(string);
        this.process(stringInfo, count);
        return this.merge(stringInfo);
    }

    private void updateCounterAndCleanUp() {
        if (this.counter.incrementAndGet() > this.cleaningCount && this.isCleaning.compareAndSet(false, true)) {
            this.counter.set(0);
            Iterator<Map.Entry<String, StringPattern>> iterator = this.stringPatternMapping.entrySet().iterator();
            while (iterator.hasNext()) {
                StringPattern stringPattern = iterator.next().getValue();
                stringPattern.divide(10);
                if (stringPattern.getPatternCount() < 1) {
                    iterator.remove();
                    continue;
                }
                for (ConcurrentHashMap<String, Term> termMapping : stringPattern.getElemMapping().values()) {
                    this.clearUpTermMapping(termMapping);
                }
            }
            this.isCleaning.compareAndSet(true, false);
        }
    }

    private void clearUpTermMapping(ConcurrentHashMap<String, Term> termMapping) {
        Iterator<Map.Entry<String, Term>> iterator = termMapping.entrySet().iterator();
        while (iterator.hasNext()) {
            Term term = iterator.next().getValue();
            term.divide(10);
            if (term.getTermCount() >= 1) continue;
            iterator.remove();
        }
    }

    private StringInfo split(String string) {
        ArrayList<String> termStrList = new ArrayList<String>(16);
        ArrayList<String> symbolList = new ArrayList<String>(16);
        String protocol = this.findProtocol(string, "http://", "https://", "ftp://");
        if (protocol.length() > 0) {
            string = string.substring(protocol.length());
        }
        int symbolIndex = -1;
        int termIndex = 0;
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char curChar = string.charAt(i);
            if (this.splitterSet.contains(Character.valueOf(curChar))) {
                if (symbolIndex != -1) continue;
                termStrList.add(string.substring(termIndex, i));
                symbolIndex = i;
                continue;
            }
            if (symbolIndex < 0) continue;
            symbolList.add(string.substring(symbolIndex, i));
            symbolIndex = -1;
            termIndex = i;
        }
        if (symbolIndex == -1) {
            termStrList.add(string.substring(termIndex));
        } else {
            symbolList.add(string.substring(symbolIndex));
        }
        return new StringInfo(protocol, termStrList, symbolList, this.concatSymbol(symbolList));
    }

    private String findProtocol(String string, String ... protocols) {
        for (String protocol : protocols) {
            if (!string.startsWith(protocol)) continue;
            return protocol;
        }
        return "";
    }

    private String concatSymbol(List<String> symbolList) {
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < symbolList.size(); ++i) {
            sb.append(symbolList.get(i)).append(i);
        }
        return sb.toString();
    }

    private void process(StringInfo stringInfo, int count) {
        ConcurrentHashMap<Integer, ConcurrentHashMap<String, Term>> elemMapping;
        StringPattern stringPattern = this.stringPatternMapping.get(stringInfo.getGroupToken());
        if (stringPattern != null) {
            stringPattern.addAndGet(count);
            elemMapping = stringPattern.getElemMapping();
        } else if (this.stringPatternMapping.size() < this.maxPatternSize) {
            elemMapping = new ConcurrentHashMap(16);
            this.stringPatternMapping.put(stringInfo.getGroupToken(), new StringPattern(elemMapping, new AtomicInteger(count)));
        } else {
            return;
        }
        List<String> termList = stringInfo.getTermStrList();
        for (int i = 0; i < termList.size(); ++i) {
            String termStr;
            Term term;
            ConcurrentHashMap<String, Term> termMapping = elemMapping.get(i);
            if (termMapping == null) {
                termMapping = new ConcurrentHashMap(16);
                elemMapping.put(i, termMapping);
            }
            if ((term = termMapping.get(termStr = termList.get(i))) != null) {
                term.addAndGet(count);
                continue;
            }
            if (termMapping.size() >= this.maxTermSize) continue;
            termMapping.put(termStr, new Term(termStr, new AtomicInteger(count)));
        }
    }

    private String merge(StringInfo stringInfo) {
        List<String> termStrList = stringInfo.getTermStrList();
        List<String> symbolList = stringInfo.getSymbolList();
        int termSize = termStrList.size();
        String patternKey = stringInfo.getGroupToken();
        StringBuilder sb = new StringBuilder(128);
        boolean termIsMore = termSize > symbolList.size();
        sb.append(stringInfo.getProtocol());
        boolean preStar = false;
        for (int i = 0; i < termSize; ++i) {
            String termStr = termStrList.get(i);
            boolean isStar = this.needConvergent(this.stringPatternMapping.get(patternKey), termStr, i);
            if (this.mergeStar && isStar && preStar) continue;
            preStar = isStar;
            sb.append(isStar ? this.variable : termStr);
            if (termIsMore && i == termSize - 1) continue;
            sb.append(symbolList.get(i));
        }
        return sb.toString();
    }

    private boolean needConvergent(StringPattern stringPattern, String termStr, int index) {
        int minCount;
        int topN;
        if (stringPattern == null || StringUtils.isEmpty(termStr)) {
            return false;
        }
        if (this.ignoreNumber && this.isNumber(termStr)) {
            return true;
        }
        Term term = stringPattern.getElemMapping().get(index).get(termStr);
        if (term == null) {
            return true;
        }
        int largerTermCount = 0;
        int curCount = term.getTermCount();
        int patternCount = stringPattern.getPatternCount();
        if (patternCount < this.patternSizeLevelOne) {
            topN = 20;
            minCount = 1;
        } else if (patternCount < this.patternSizeLevelTwo) {
            topN = 10;
            minCount = 5;
        } else {
            topN = 5;
            minCount = 10;
        }
        if (curCount < minCount) {
            return true;
        }
        for (Term t : stringPattern.getElemMapping().get(index).values()) {
            if (t.getTermCount() > curCount) {
                ++largerTermCount;
            }
            if (largerTermCount < topN) continue;
            return true;
        }
        return false;
    }

    private boolean isNumber(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }
}

