/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.plugin;

import com.navercorp.pinpoint.common.plugin.PluginLoaderClassLoader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class PluginLoader {
    private static final SecurityManager SECURITY_MANAGER = System.getSecurityManager();

    public static <T> List<T> load(Class<T> serviceType, URL[] urls) {
        PluginLoaderClassLoader classLoader = PluginLoader.createPluginClassLoader(urls, ClassLoader.getSystemClassLoader());
        return PluginLoader.load(serviceType, classLoader);
    }

    private static PluginLoaderClassLoader createPluginClassLoader(final URL[] urls, final ClassLoader parent) {
        if (SECURITY_MANAGER != null) {
            return AccessController.doPrivileged(new PrivilegedAction<PluginLoaderClassLoader>(){

                @Override
                public PluginLoaderClassLoader run() {
                    return new PluginLoaderClassLoader(urls, parent);
                }
            });
        }
        return new PluginLoaderClassLoader(urls, parent);
    }

    public static <T> List<T> load(Class<T> serviceType, ClassLoader classLoader) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(serviceType, classLoader);
        ArrayList<T> plugins = new ArrayList<T>();
        for (T plugin : serviceLoader) {
            plugins.add(serviceType.cast(plugin));
        }
        return plugins;
    }
}

