/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.NoSuchElementException;

public class AnnotationKeyRegistry {
    private final IntHashMap<AnnotationKey> codeLookupTable;
    private final HashMap<String, AnnotationKey> nameLookupTable;
    private final IntHashMap<AnnotationKey> apiErrorLookupTable;

    public AnnotationKeyRegistry(HashMap<Integer, AnnotationKey> buildMap) {
        if (buildMap == null) {
            throw new NullPointerException("buildMap must not be null");
        }
        this.codeLookupTable = IntHashMapUtils.copy(buildMap);
        this.nameLookupTable = this.buildNameTable(buildMap.values());
        this.apiErrorLookupTable = this.buildApiMetaDataError(buildMap.values());
    }

    private HashMap<String, AnnotationKey> buildNameTable(Collection<AnnotationKey> buildMap) {
        HashMap<String, AnnotationKey> nameLookupTable = new HashMap<String, AnnotationKey>();
        for (AnnotationKey annotationKey : buildMap) {
            AnnotationKey exist = nameLookupTable.put(annotationKey.getName(), annotationKey);
            if (exist == null) continue;
            AnnotationKeyRegistry.throwDuplicatedAnnotationKey(annotationKey, exist);
        }
        return nameLookupTable;
    }

    private static void throwDuplicatedAnnotationKey(AnnotationKey annotationKey, AnnotationKey exist) {
        throw new IllegalStateException("already exist. annotationKey:" + annotationKey + ", exist:" + exist);
    }

    private IntHashMap<AnnotationKey> buildApiMetaDataError(Collection<AnnotationKey> buildMap) {
        IntHashMap<AnnotationKey> table = new IntHashMap<AnnotationKey>();
        for (AnnotationKey annotationKey : buildMap) {
            if (!annotationKey.isErrorApiMetadata()) continue;
            table.put(annotationKey.getCode(), annotationKey);
        }
        return table;
    }

    public AnnotationKey findAnnotationKey(int code) {
        AnnotationKey annotationKey = this.codeLookupTable.get(code);
        if (annotationKey == null) {
            return AnnotationKey.UNKNOWN;
        }
        return annotationKey;
    }

    public AnnotationKey findAnnotationKeyByName(String keyName) {
        AnnotationKey annotationKey = this.nameLookupTable.get(keyName);
        if (annotationKey == null) {
            throw new NoSuchElementException(keyName);
        }
        return annotationKey;
    }

    public AnnotationKey findApiErrorCode(int annotationCode) {
        return this.apiErrorLookupTable.get(annotationCode);
    }

    public static class Builder {
        private final HashMap<Integer, AnnotationKey> buildMap = new HashMap();

        public void addAnnotationKey(AnnotationKey annotationKey) {
            if (annotationKey == null) {
                throw new NullPointerException("annotationKey must not be null");
            }
            int code = annotationKey.getCode();
            AnnotationKey exist = this.buildMap.put(code, annotationKey);
            if (exist != null) {
                AnnotationKeyRegistry.throwDuplicatedAnnotationKey(annotationKey, exist);
            }
        }

        public AnnotationKeyRegistry build() {
            return new AnnotationKeyRegistry(this.buildMap);
        }
    }
}

