/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.buffer.AutomaticBuffer;
import com.navercorp.pinpoint.common.buffer.FixedBuffer;
import com.navercorp.pinpoint.common.util.BitFieldUtils;
import com.navercorp.pinpoint.common.util.BytesUtils;
import com.navercorp.pinpoint.common.util.IntBooleanIntBooleanValue;
import com.navercorp.pinpoint.common.util.IntStringStringValue;
import com.navercorp.pinpoint.common.util.IntStringValue;
import com.navercorp.pinpoint.common.util.LongIntIntByteByteStringValue;
import com.navercorp.pinpoint.thrift.dto.TAnnotation;
import com.navercorp.pinpoint.thrift.dto.TAnnotationValue;
import com.navercorp.pinpoint.thrift.dto.TIntBooleanIntBooleanValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringStringValue;
import com.navercorp.pinpoint.thrift.dto.TIntStringValue;
import com.navercorp.pinpoint.thrift.dto.TLongIntIntByteByteStringValue;

public class AnnotationTranscoder {
    static final byte CODE_STRING = 0;
    static final byte CODE_NULL = 1;
    static final byte CODE_INT = 2;
    static final byte CODE_LONG = 3;
    static final byte CODE_BOOLEAN_TRUE = 4;
    static final byte CODE_BOOLEAN_FALSE = 5;
    static final byte CODE_BYTEARRAY = 6;
    static final byte CODE_BYTE = 7;
    static final byte CODE_SHORT = 8;
    static final byte CODE_FLOAT = 9;
    static final byte CODE_DOUBLE = 10;
    static final byte CODE_TOSTRING = 11;
    static final byte CODE_INT_STRING = 20;
    static final byte CODE_INT_STRING_STRING = 21;
    static final byte CODE_LONG_INT_INT_BYTE_BYTE_STRING = 22;
    static final byte CODE_INT_BOOLEAN_INT_BOOLEAN = 23;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public Object getMappingValue(TAnnotation annotation) {
        TAnnotationValue value = annotation.getValue();
        if (value == null) {
            return null;
        }
        return value.getFieldValue();
    }

    public Object decode(byte dataType, byte[] data) {
        switch (dataType) {
            case 0: {
                return this.decodeString(data);
            }
            case 4: {
                return Boolean.TRUE;
            }
            case 5: {
                return Boolean.FALSE;
            }
            case 2: {
                return BytesUtils.bytesToSVar32(data, 0);
            }
            case 3: {
                return BytesUtils.bytesToSVar64(data, 0);
            }
            case 7: {
                return data[0];
            }
            case 8: {
                return (short)BytesUtils.bytesToSVar32(data, 0);
            }
            case 9: {
                return Float.valueOf(Float.intBitsToFloat(BytesUtils.bytesToInt(data, 0)));
            }
            case 10: {
                return Double.longBitsToDouble(BytesUtils.bytesToLong(data, 0));
            }
            case 6: {
                return data;
            }
            case 1: {
                return null;
            }
            case 11: {
                return this.decodeString(data);
            }
            case 20: {
                return this.decodeIntStringValue(data);
            }
            case 21: {
                return this.decodeIntStringStringValue(data);
            }
            case 22: {
                return this.decodeLongIntIntByteByteStringValue(data);
            }
            case 23: {
                return this.decodeIntBooleanIntBooleanValue(data);
            }
        }
        throw new IllegalArgumentException("unsupported DataType:" + dataType);
    }

    public byte getTypeCode(Object o) {
        if (o == null) {
            return 1;
        }
        if (o instanceof String) {
            return 0;
        }
        if (o instanceof Long) {
            return 3;
        }
        if (o instanceof Integer) {
            return 2;
        }
        if (o instanceof Boolean) {
            if (Boolean.TRUE.equals(o)) {
                return 4;
            }
            return 5;
        }
        if (o instanceof Byte) {
            return 7;
        }
        if (o instanceof Short) {
            return 8;
        }
        if (o instanceof Float) {
            return 9;
        }
        if (o instanceof Double) {
            return 10;
        }
        if (o instanceof byte[]) {
            return 6;
        }
        if (o instanceof TIntStringValue) {
            return 20;
        }
        if (o instanceof TIntStringStringValue) {
            return 21;
        }
        if (o instanceof TLongIntIntByteByteStringValue) {
            return 22;
        }
        if (o instanceof TIntBooleanIntBooleanValue) {
            return 23;
        }
        return 11;
    }

    public byte[] encode(Object o, int typeCode) {
        switch (typeCode) {
            case 0: {
                return this.encodeString((String)o);
            }
            case 2: {
                return BytesUtils.intToSVar32((Integer)o);
            }
            case 4: {
                return EMPTY_BYTE_ARRAY;
            }
            case 5: {
                return EMPTY_BYTE_ARRAY;
            }
            case 3: {
                return BytesUtils.longToSVar64((Long)o);
            }
            case 7: {
                byte[] bytes = new byte[]{(Byte)o};
                return bytes;
            }
            case 8: {
                return BytesUtils.intToSVar32(((Short)o).shortValue());
            }
            case 9: {
                byte[] buffer = new byte[4];
                BytesUtils.writeInt(Float.floatToRawIntBits(((Float)o).floatValue()), buffer, 0);
                return buffer;
            }
            case 10: {
                byte[] buffer = new byte[8];
                BytesUtils.writeLong(Double.doubleToRawLongBits((Double)o), buffer, 0);
                return buffer;
            }
            case 6: {
                return (byte[])o;
            }
            case 1: {
                return null;
            }
            case 11: {
                String str = o.toString();
                return this.encodeString(str);
            }
            case 20: {
                return this.encodeIntStringValue(o);
            }
            case 21: {
                return this.encodeIntStringStringValue(o);
            }
            case 22: {
                return this.encodeLongIntIntByteByteStringValue(o);
            }
            case 23: {
                return this.encodeIntBooleanIntBooleanValue(o);
            }
        }
        throw new IllegalArgumentException("unsupported DataType:" + typeCode + " data:" + o);
    }

    private Object decodeIntStringValue(byte[] data) {
        FixedBuffer buffer = new FixedBuffer(data);
        int intValue = buffer.readSVInt();
        String stringValue = BytesUtils.toString(buffer.readPrefixedBytes());
        return new IntStringValue(intValue, stringValue);
    }

    private byte[] encodeIntStringValue(Object value) {
        TIntStringValue tIntStringValue = (TIntStringValue)value;
        int intValue = tIntStringValue.getIntValue();
        byte[] stringValue = BytesUtils.toBytes(tIntStringValue.getStringValue());
        int bufferSize = this.getBufferSize(stringValue, 12);
        AutomaticBuffer buffer = new AutomaticBuffer(bufferSize);
        buffer.putSVInt(intValue);
        buffer.putPrefixedBytes(stringValue);
        return buffer.getBuffer();
    }

    private int getBufferSize(byte[] stringValue, int reserve) {
        if (stringValue == null) {
            return reserve;
        }
        return stringValue.length + reserve;
    }

    private Object decodeIntStringStringValue(byte[] data) {
        FixedBuffer buffer = new FixedBuffer(data);
        int intValue = buffer.readSVInt();
        String stringValue1 = BytesUtils.toString(buffer.readPrefixedBytes());
        String stringValue2 = BytesUtils.toString(buffer.readPrefixedBytes());
        return new IntStringStringValue(intValue, stringValue1, stringValue2);
    }

    private byte[] encodeIntStringStringValue(Object o) {
        TIntStringStringValue tIntStringStringValue = (TIntStringStringValue)o;
        int intValue = tIntStringStringValue.getIntValue();
        byte[] stringValue1 = BytesUtils.toBytes(tIntStringStringValue.getStringValue1());
        byte[] stringValue2 = BytesUtils.toBytes(tIntStringStringValue.getStringValue2());
        int bufferSize = this.getBufferSize(stringValue1, stringValue2, 12);
        AutomaticBuffer buffer = new AutomaticBuffer(bufferSize);
        buffer.putSVInt(intValue);
        buffer.putPrefixedBytes(stringValue1);
        buffer.putPrefixedBytes(stringValue2);
        return buffer.getBuffer();
    }

    private int getBufferSize(byte[] stringValue1, byte[] stringValue2, int reserve) {
        int length = 0;
        if (stringValue1 != null) {
            length += stringValue1.length;
        }
        if (stringValue2 != null) {
            length += stringValue2.length;
        }
        return length + reserve;
    }

    private Object decodeLongIntIntByteByteStringValue(byte[] data) {
        FixedBuffer buffer = new FixedBuffer(data);
        byte bitField = buffer.readByte();
        long longValue = buffer.readVLong();
        int intValue1 = buffer.readSVInt();
        int intValue2 = -1;
        if (BitFieldUtils.testBit(bitField, 0)) {
            intValue2 = buffer.readVInt();
        }
        byte byteValue1 = -1;
        if (BitFieldUtils.testBit(bitField, 1)) {
            byteValue1 = buffer.readByte();
        }
        byte byteValue2 = -1;
        if (BitFieldUtils.testBit(bitField, 2)) {
            byteValue2 = buffer.readByte();
        }
        String stringValue = null;
        if (BitFieldUtils.testBit(bitField, 3)) {
            stringValue = BytesUtils.toString(buffer.readPrefixedBytes());
        }
        return new LongIntIntByteByteStringValue(longValue, intValue1, intValue2, byteValue1, byteValue2, stringValue);
    }

    private byte[] encodeLongIntIntByteByteStringValue(Object o) {
        TLongIntIntByteByteStringValue value = (TLongIntIntByteByteStringValue)o;
        byte bitField = 0;
        bitField = BitFieldUtils.setBit(bitField, 0, value.isSetIntValue2());
        bitField = BitFieldUtils.setBit(bitField, 1, value.isSetByteValue1());
        bitField = BitFieldUtils.setBit(bitField, 2, value.isSetByteValue2());
        bitField = BitFieldUtils.setBit(bitField, 3, value.isSetStringValue());
        byte[] stringValue = BytesUtils.toBytes(value.getStringValue());
        int bufferSize = this.getBufferSize(stringValue, 19);
        AutomaticBuffer buffer = new AutomaticBuffer(bufferSize);
        buffer.putByte(bitField);
        buffer.putVLong(value.getLongValue());
        buffer.putSVInt(value.getIntValue1());
        if (value.isSetIntValue2()) {
            buffer.putVInt(value.getIntValue2());
        }
        if (value.isSetByteValue1()) {
            buffer.putByte(value.getByteValue1());
        }
        if (value.isSetByteValue2()) {
            buffer.putByte(value.getByteValue2());
        }
        if (value.isSetStringValue()) {
            buffer.putPrefixedBytes(stringValue);
        }
        return buffer.getBuffer();
    }

    private Object decodeIntBooleanIntBooleanValue(byte[] data) {
        FixedBuffer buffer = new FixedBuffer(data);
        int intValue1 = buffer.readVInt();
        boolean booleanValue1 = buffer.readBoolean();
        int intValue2 = buffer.readVInt();
        boolean booleanValue2 = buffer.readBoolean();
        return new IntBooleanIntBooleanValue(intValue1, booleanValue1, intValue2, booleanValue2);
    }

    private byte[] encodeIntBooleanIntBooleanValue(Object o) {
        TIntBooleanIntBooleanValue value = (TIntBooleanIntBooleanValue)o;
        AutomaticBuffer buffer = new AutomaticBuffer(8);
        buffer.putVInt(value.getIntValue1());
        buffer.putBoolean(value.isBoolValue1());
        buffer.putVInt(value.getIntValue2());
        buffer.putBoolean(value.isBoolValue2());
        return buffer.getBuffer();
    }

    protected String decodeString(byte[] data) {
        return BytesUtils.toString(data);
    }

    protected byte[] encodeString(String in) {
        return BytesUtils.toBytes(in);
    }
}

