/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

public final class ArrayUtils {
    private static final int DEFAULT_ABBREVIATE_MAX_WIDTH = 32;

    private ArrayUtils() {
    }

    public static String abbreviate(byte[] bytes) {
        return ArrayUtils.abbreviate(bytes, 32);
    }

    public static String abbreviate(byte[] bytes, int maxWidth) {
        if (bytes == null) {
            return "null";
        }
        if (maxWidth < 0) {
            throw new IllegalArgumentException("negative maxWidth:" + maxWidth);
        }
        int bytesMaxLength = bytes.length - 1;
        int maxLimit = maxWidth - 1;
        if (bytesMaxLength > maxLimit) {
            bytesMaxLength = maxLimit;
        }
        if (bytesMaxLength == -1) {
            if (bytes.length == 0) {
                return "[]";
            }
            return "[...(" + bytes.length + ")]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        int i = 0;
        while (true) {
            sb.append(bytes[i]);
            if (i == bytesMaxLength) {
                if (bytes.length - 1 <= maxLimit) {
                    return sb.append(']').toString();
                }
                sb.append(", ...(");
                sb.append(bytes.length - (i + 1));
                sb.append(")]");
                return sb.toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(long[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(int[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(short[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(char[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(double[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(float[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(boolean[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean hasLength(T[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(long[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(int[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(short[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(char[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(byte[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(double[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(float[] array) {
        return array != null && array.length != 0;
    }

    public static boolean hasLength(boolean[] array) {
        return array != null && array.length != 0;
    }

    public static int getLength(long[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(int[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(short[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(char[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(byte[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(double[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(float[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static int getLength(boolean[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }

    public static <T> int getLength(T[] array) {
        if (array == null) {
            return 0;
        }
        return array.length;
    }
}

