/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

public final class ClassLoaderUtils {
    public static final ClassLoaderCallable DEFAULT_CLASS_LOADER_CALLABLE = new ClassLoaderCallable(){

        @Override
        public ClassLoader getClassLoader() {
            return ClassLoaderUtils.class.getClassLoader();
        }
    };
    private static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    private static final ClassLoader EXT_CLASS_LOADER = SYSTEM_CLASS_LOADER != null ? SYSTEM_CLASS_LOADER.getParent() : null;
    private static final ClassLoader BOOT_CLASS_LOADER = EXT_CLASS_LOADER != null ? EXT_CLASS_LOADER.getParent() : null;

    private ClassLoaderUtils() {
    }

    public static ClassLoader getDefaultClassLoader() {
        return ClassLoaderUtils.getDefaultClassLoader(DEFAULT_CLASS_LOADER_CALLABLE);
    }

    public static ClassLoader getDefaultClassLoader(ClassLoaderCallable defaultClassLoaderCallable) {
        if (defaultClassLoaderCallable == null) {
            throw new NullPointerException("defaultClassLoaderCallable must not be null");
        }
        try {
            Thread th = Thread.currentThread();
            ClassLoader contextClassLoader = th.getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return defaultClassLoaderCallable.getClassLoader();
    }

    public static boolean isJvmClassLoader(ClassLoader classLoader) {
        return BOOT_CLASS_LOADER == classLoader || SYSTEM_CLASS_LOADER == classLoader || EXT_CLASS_LOADER == classLoader;
    }

    public static String dumpStandardClassLoader() {
        StringBuilder buffer = new StringBuilder();
        ClassLoaderUtils.appendClassLoaderLog(buffer, "SYSTEM_CLASS_LOADER", SYSTEM_CLASS_LOADER);
        ClassLoaderUtils.appendClassLoaderLog(buffer, "EXT_CLASS_LOADER", EXT_CLASS_LOADER);
        ClassLoaderUtils.appendClassLoaderLog(buffer, "BOOT_CLASS_LOADER", BOOT_CLASS_LOADER);
        return buffer.toString();
    }

    private static void appendClassLoaderLog(StringBuilder buffer, String classLoaderName, ClassLoader classLoader) {
        buffer.append(classLoaderName);
        buffer.append(':');
        if (classLoader == null) {
            buffer.append("null");
        } else {
            buffer.append(classLoader.toString());
        }
        buffer.append(", ");
    }

    public static interface ClassLoaderCallable {
        public ClassLoader getClassLoader();
    }
}

