/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public final class NetUtils {
    public static final String LOOPBACK_ADDRESS_V4 = "127.0.0.1";

    private NetUtils() {
    }

    public static List<InetSocketAddress> toInetSocketAddressLIst(List<String> addressList) {
        ArrayList<InetSocketAddress> inetSocketAddressList = new ArrayList<InetSocketAddress>();
        for (String address : addressList) {
            InetSocketAddress inetSocketAddress = NetUtils.toInetSocketAddress(address);
            if (inetSocketAddress == null) continue;
            inetSocketAddressList.add(inetSocketAddress);
        }
        return inetSocketAddressList;
    }

    public static InetSocketAddress toInetSocketAddress(String address) {
        try {
            URI uri = new URI("pinpoint://" + address);
            return new InetSocketAddress(uri.getHost(), uri.getPort());
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public static String getLocalV4Ip() {
        try {
            InetAddress localHost = InetAddress.getLocalHost();
            String localIp = localHost.getHostAddress();
            if (NetUtils.validationIpV4FormatAddress(localIp)) {
                return localIp;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return LOOPBACK_ADDRESS_V4;
    }

    public static List<String> getLocalV4IpList() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<NetworkInterface> interfaces = null;
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        if (interfaces == null) {
            return Collections.emptyList();
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface current = interfaces.nextElement();
            if (NetUtils.isSkipIp(current)) continue;
            Enumeration<InetAddress> addresses = current.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isLoopbackAddress() || !(address instanceof Inet4Address) || !NetUtils.validationIpV4FormatAddress(address.getHostAddress())) continue;
                result.add(address.getHostAddress());
            }
        }
        return result;
    }

    private static boolean isSkipIp(NetworkInterface networkInterface) {
        try {
            return !networkInterface.isUp() || networkInterface.isLoopback() || networkInterface.isVirtual();
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static boolean validationIpPortV4FormatAddress(String address) {
        try {
            int splitIndex = address.indexOf(58);
            if (splitIndex == -1 || splitIndex + 1 >= address.length()) {
                return false;
            }
            String ip = address.substring(0, splitIndex);
            if (!NetUtils.validationIpV4FormatAddress(ip)) {
                return false;
            }
            String port = address.substring(splitIndex + 1, address.length());
            return Integer.parseInt(port) <= 65535;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean validationIpV4FormatAddress(String address) {
        try {
            String[] eachDotAddress = address.split("\\.");
            if (eachDotAddress.length != 4) {
                return false;
            }
            for (String eachAddress : eachDotAddress) {
                if (Integer.parseInt(eachAddress) <= 255) continue;
                return false;
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }
}

