/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.util;

import com.navercorp.pinpoint.common.Charsets;
import com.navercorp.pinpoint.common.util.ClassLoaderUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;

public final class PropertyUtils {
    public static final String DEFAULT_ENCODING = Charsets.UTF_8_NAME;
    private static final ClassLoaderUtils.ClassLoaderCallable CLASS_LOADER_CALLABLE = new ClassLoaderUtils.ClassLoaderCallable(){

        @Override
        public ClassLoader getClassLoader() {
            return PropertyUtils.class.getClassLoader();
        }
    };

    private PropertyUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushProperty(String filePath, Properties properties) throws IOException {
        FileInputStream in = null;
        BufferedReader reader = null;
        OutputStreamWriter writer = null;
        try {
            in = new FileInputStream(filePath);
            reader = new BufferedReader(new InputStreamReader((InputStream)in, DEFAULT_ENCODING));
            StringBuilder content = new StringBuilder();
            String line = reader.readLine();
            while (line != null) {
                String key;
                String value;
                String[] pair = line.split("=");
                if (pair.length >= 1 && (value = properties.getProperty(key = pair[0])) != null) {
                    line = key + "=" + value;
                }
                content.append(line).append("\n");
                line = reader.readLine();
            }
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), DEFAULT_ENCODING);
            writer.write(content.toString());
        }
        catch (Throwable throwable) {
            PropertyUtils.close(reader);
            PropertyUtils.close(in);
            PropertyUtils.close(writer);
            throw throwable;
        }
        PropertyUtils.close(reader);
        PropertyUtils.close(in);
        PropertyUtils.close(writer);
    }

    public static Properties loadProperty(final String filePath) throws IOException {
        if (filePath == null) {
            throw new NullPointerException("filePath must not be null");
        }
        InputStreamFactory inputStreamFactory = new InputStreamFactory(){

            @Override
            public InputStream openInputStream() throws IOException {
                return new FileInputStream(filePath);
            }
        };
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    public static Properties loadPropertyFromClassPath(final String classPath) throws IOException {
        if (classPath == null) {
            throw new NullPointerException("classPath must not be null");
        }
        InputStreamFactory inputStreamFactory = new InputStreamFactory(){

            @Override
            public InputStream openInputStream() throws IOException {
                return ClassLoaderUtils.getDefaultClassLoader(CLASS_LOADER_CALLABLE).getResourceAsStream(classPath);
            }
        };
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    public static Properties loadPropertyFromClassLoader(final ClassLoader classLoader, final String classPath) throws IOException {
        if (classLoader == null) {
            throw new NullPointerException("classLoader must not be null");
        }
        InputStreamFactory inputStreamFactory = new InputStreamFactory(){

            @Override
            public InputStream openInputStream() throws IOException {
                return classLoader.getResourceAsStream(classPath);
            }
        };
        return PropertyUtils.loadProperty(new Properties(), inputStreamFactory, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadProperty(Properties properties, InputStreamFactory inputStreamFactory, String encoding) throws IOException {
        if (properties == null) {
            throw new NullPointerException("properties must not be null");
        }
        if (inputStreamFactory == null) {
            throw new NullPointerException("inputStreamFactory must not be null");
        }
        if (encoding == null) {
            throw new NullPointerException("encoding must not be null");
        }
        InputStream in = null;
        InputStreamReader reader = null;
        try {
            in = inputStreamFactory.openInputStream();
            reader = new InputStreamReader(in, encoding);
            properties.load(reader);
        }
        catch (Throwable throwable) {
            PropertyUtils.close(reader);
            PropertyUtils.close(in);
            throw throwable;
        }
        PropertyUtils.close(reader);
        PropertyUtils.close(in);
        return properties;
    }

    private static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static interface InputStreamFactory {
        public InputStream openInputStream() throws IOException;
    }
}

