/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc;

import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.common.SocketStateCode;
import java.util.concurrent.Executor;

public abstract class ExecutionThreadStateChangeEventHandler<S extends PinpointSocket>
implements StateChangeEventListener<S> {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final StateChangeEventListener handler;
    private final Executor executor;

    public ExecutionThreadStateChangeEventHandler(StateChangeEventListener handler, Executor executor) {
        this.handler = handler;
        this.executor = executor;
    }

    @Override
    public void eventPerformed(S pinpointSocket, SocketStateCode stateCode) {
        Execution execution = new Execution(this, pinpointSocket, stateCode);
        this.executor.execute(execution);
    }

    private static class Execution
    implements Runnable {
        private final S pinpointSocket;
        private final SocketStateCode stateCode;
        final /* synthetic */ ExecutionThreadStateChangeEventHandler this$0;

        public Execution(S pinpointSocket, SocketStateCode stateCode) {
            this.this$0 = var1_1;
            this.pinpointSocket = pinpointSocket;
            this.stateCode = stateCode;
        }

        @Override
        public void run() {
            try {
                this.this$0.handler.eventPerformed(this.pinpointSocket, this.stateCode);
            }
            catch (Exception e) {
                this.this$0.handler.exceptionCaught(this.pinpointSocket, this.stateCode, e);
            }
        }
    }
}

