/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConnectFuture {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final AtomicReferenceFieldUpdater<ConnectFuture, Result> FIELD_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConnectFuture.class, Result.class, "result");
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile Result result;

    public Result getResult() {
        return this.result;
    }

    void setResult(Result connectResult) {
        Result result = this.result;
        if (result == null && FIELD_UPDATER.compareAndSet(this, null, connectResult)) {
            this.latch.countDown();
        }
    }

    public void await() throws InterruptedException {
        this.latch.await();
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.latch.await(timeout, timeUnit);
    }

    public void awaitUninterruptibly() {
        while (true) {
            try {
                this.await();
                return;
            }
            catch (InterruptedException e) {
                this.logger.debug(e.getMessage(), e);
                continue;
            }
            break;
        }
    }

    public static enum Result {
        SUCCESS,
        FAIL;

    }
}

