/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelPipeline;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelPipelineFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channels;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.handler.timeout.WriteTimeoutHandler;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientFactory;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientHandler;
import com.navercorp.pinpoint.rpc.codec.PacketDecoder;
import com.navercorp.pinpoint.rpc.codec.PacketEncoder;
import java.util.concurrent.TimeUnit;

public class PinpointClientPipelineFactory
implements ChannelPipelineFactory {
    private final DefaultPinpointClientFactory pinpointClientFactory;

    public PinpointClientPipelineFactory(DefaultPinpointClientFactory pinpointClientFactory) {
        if (pinpointClientFactory == null) {
            throw new NullPointerException("pinpointClientFactory must not be null");
        }
        this.pinpointClientFactory = pinpointClientFactory;
    }

    @Override
    public ChannelPipeline getPipeline() throws Exception {
        ChannelPipeline pipeline = Channels.pipeline();
        pipeline.addLast("encoder", new PacketEncoder());
        pipeline.addLast("decoder", new PacketDecoder());
        long pingDelay = this.pinpointClientFactory.getPingDelay();
        long enableWorkerPacketDelay = this.pinpointClientFactory.getEnableWorkerPacketDelay();
        long timeoutMillis = this.pinpointClientFactory.getTimeoutMillis();
        DefaultPinpointClientHandler defaultPinpointClientHandler = new DefaultPinpointClientHandler(this.pinpointClientFactory, pingDelay, enableWorkerPacketDelay, timeoutMillis);
        pipeline.addLast("writeTimeout", new WriteTimeoutHandler(defaultPinpointClientHandler.getChannelTimer(), 3000L, TimeUnit.MILLISECONDS));
        pipeline.addLast("socketHandler", defaultPinpointClientHandler);
        return pipeline;
    }
}

