/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.packet.stream;

import com.navercorp.pinpoint.common.util.apache.IntHashMap;

public enum StreamCode {
    OK(0),
    UNKNWON_ERROR(100),
    ID_ERROR(110),
    ID_ILLEGAL(111),
    ID_DUPLICATED(112),
    ID_NOT_FOUND(113),
    STATE_ERROR(120),
    STATE_NOT_CONNECTED(121),
    STATE_CLOSED(122),
    TYPE_ERROR(130),
    TYPE_UNKNOWN(131),
    TYPE_UNSUPPORT(132),
    PACKET_ERROR(140),
    PACKET_UNKNOWN(141),
    PACKET_UNSUPPORT(142),
    CONNECTION_ERRROR(150),
    CONNECTION_NOT_FOUND(151),
    CONNECTION_TIMEOUT(152),
    CONNECTION_UNSUPPORT(153),
    ROUTE_ERROR(160);

    private final short value;
    private static final IntHashMap<StreamCode> CODE_MAP;

    private StreamCode(short value) {
        this.value = value;
    }

    public static StreamCode getCode(short value) {
        StreamCode streamCode = CODE_MAP.get(value);
        if (streamCode != null) {
            return streamCode;
        }
        short codeGroup = (short)(value - value % 10);
        streamCode = CODE_MAP.get(codeGroup);
        if (streamCode != null) {
            return streamCode;
        }
        return UNKNWON_ERROR;
    }

    private static IntHashMap<StreamCode> initializeCodeMapping() {
        IntHashMap<StreamCode> codeMap = new IntHashMap<StreamCode>();
        for (StreamCode streamCode : StreamCode.values()) {
            codeMap.put(streamCode.value, streamCode);
        }
        return codeMap;
    }

    public short value() {
        return this.value;
    }

    static {
        CODE_MAP = StreamCode.initializeCodeMapping();
    }
}

