/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.server;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.bootstrap.ServerBootstrap;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFuture;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFutureListener;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelHandlerContext;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelPipelineFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelStateEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ExceptionEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.MessageEvent;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.SimpleChannelHandler;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.group.ChannelGroup;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.group.DefaultChannelGroup;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioServerBossPool;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioWorker;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.NioWorkerPool;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.socket.nio.WorkerPool;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.ThreadNameDeterminer;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.util.Timer;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.common.util.CpuUtils;
import com.navercorp.pinpoint.common.util.PinpointThreadFactory;
import com.navercorp.pinpoint.rpc.PinpointSocket;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.packet.ServerClosePacket;
import com.navercorp.pinpoint.rpc.server.DefaultPinpointServer;
import com.navercorp.pinpoint.rpc.server.HealthCheckManager;
import com.navercorp.pinpoint.rpc.server.PinpointServerConfig;
import com.navercorp.pinpoint.rpc.server.ServerMessageListener;
import com.navercorp.pinpoint.rpc.server.ServerPipelineFactory;
import com.navercorp.pinpoint.rpc.server.SimpleServerMessageListener;
import com.navercorp.pinpoint.rpc.server.handler.ServerStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.DisabledServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.util.LoggerFactorySetup;
import com.navercorp.pinpoint.rpc.util.TimerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PinpointServerAcceptor
implements PinpointServerConfig {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_TIMEOUTMILLIS = 3000L;
    private static final long CHANNEL_CLOSE_MAXIMUM_WAITING_TIME_MILLIS = 3000L;
    private static final int HEALTH_CHECK_INTERVAL_TIME_MILLIS = 300000;
    private static final int WORKER_COUNT = CpuUtils.workerCount();
    private volatile boolean released;
    private ServerBootstrap bootstrap;
    private InetAddress[] ignoreAddressList;
    private Channel serverChannel;
    private final ChannelGroup channelGroup = new DefaultChannelGroup("PinpointServerFactory");
    private final PinpointServerChannelHandler nettyChannelHandler = new PinpointServerChannelHandler();
    private ServerMessageListener messageListener = SimpleServerMessageListener.SIMPLEX_INSTANCE;
    private ServerStreamChannelMessageListener serverStreamChannelMessageListener = DisabledServerStreamChannelMessageListener.INSTANCE;
    private List<ServerStateChangeEventHandler> stateChangeEventHandler = new ArrayList<ServerStateChangeEventHandler>();
    private final Timer healthCheckTimer;
    private final HealthCheckManager healthCheckManager;
    private final Timer requestManagerTimer;
    private final ClusterOption clusterOption;
    private long defaultRequestTimeout = 3000L;

    public PinpointServerAcceptor() {
        this(ClusterOption.DISABLE_CLUSTER_OPTION);
    }

    public PinpointServerAcceptor(ClusterOption clusterOption) {
        ServerBootstrap bootstrap = this.createBootStrap(1, WORKER_COUNT);
        this.setOptions(bootstrap);
        this.addPipeline(bootstrap);
        this.bootstrap = bootstrap;
        this.healthCheckTimer = TimerFactory.createHashedWheelTimer("PinpointServerSocket-HealthCheckTimer", 50L, TimeUnit.MILLISECONDS, 512);
        this.healthCheckManager = new HealthCheckManager(this.healthCheckTimer, this.channelGroup);
        this.requestManagerTimer = TimerFactory.createHashedWheelTimer("PinpointServerSocket-RequestManager", 50L, TimeUnit.MILLISECONDS, 512);
        this.clusterOption = clusterOption;
    }

    private ServerBootstrap createBootStrap(int bossCount, int workerCount) {
        ExecutorService boss = Executors.newCachedThreadPool(new PinpointThreadFactory("Pinpoint-Server-Boss", true));
        NioServerBossPool nioServerBossPool = new NioServerBossPool((Executor)boss, bossCount, ThreadNameDeterminer.CURRENT);
        ExecutorService worker = Executors.newCachedThreadPool(new PinpointThreadFactory("Pinpoint-Server-Worker", true));
        NioWorkerPool nioWorkerPool = new NioWorkerPool((Executor)worker, workerCount, ThreadNameDeterminer.CURRENT);
        NioServerSocketChannelFactory nioClientSocketChannelFactory = new NioServerSocketChannelFactory(nioServerBossPool, (WorkerPool<NioWorker>)nioWorkerPool);
        return new ServerBootstrap(nioClientSocketChannelFactory);
    }

    private void setOptions(ServerBootstrap bootstrap) {
        bootstrap.setOption("child.tcpNoDelay", true);
        bootstrap.setOption("child.keepAlive", true);
        bootstrap.setOption("child.sendBufferSize", 65536);
        bootstrap.setOption("child.receiveBufferSize", 65536);
    }

    private void addPipeline(ServerBootstrap bootstrap) {
        ServerPipelineFactory serverPipelineFactory = new ServerPipelineFactory(this.nettyChannelHandler);
        bootstrap.setPipelineFactory(serverPipelineFactory);
    }

    void setPipelineFactory(ChannelPipelineFactory channelPipelineFactory) {
        if (channelPipelineFactory == null) {
            throw new NullPointerException("channelPipelineFactory must not be null");
        }
        this.bootstrap.setPipelineFactory(channelPipelineFactory);
    }

    public void bind(String host, int port) throws PinpointSocketException {
        InetSocketAddress bindAddress = new InetSocketAddress(host, port);
        this.bind(bindAddress);
    }

    public void bind(InetSocketAddress bindAddress) throws PinpointSocketException {
        if (this.released) {
            return;
        }
        this.logger.info("bind() {}", (Object)bindAddress);
        this.serverChannel = this.bootstrap.bind(bindAddress);
        this.healthCheckManager.start(300000L);
    }

    private DefaultPinpointServer createPinpointServer(Channel channel) {
        DefaultPinpointServer pinpointServer = new DefaultPinpointServer(channel, this);
        return pinpointServer;
    }

    @Override
    public long getDefaultRequestTimeout() {
        return this.defaultRequestTimeout;
    }

    public void setDefaultRequestTimeout(long defaultRequestTimeout) {
        this.defaultRequestTimeout = defaultRequestTimeout;
    }

    private boolean isIgnoreAddress(Channel channel) {
        if (this.ignoreAddressList == null) {
            return false;
        }
        InetSocketAddress remoteAddress = (InetSocketAddress)channel.getRemoteAddress();
        if (remoteAddress == null) {
            return false;
        }
        InetAddress address = remoteAddress.getAddress();
        for (InetAddress ignore : this.ignoreAddressList) {
            if (!ignore.equals(address)) continue;
            return true;
        }
        return false;
    }

    public void setIgnoreAddressList(InetAddress[] ignoreAddressList) {
        Assert.requireNonNull(ignoreAddressList, "ignoreAddressList must not be null");
        this.ignoreAddressList = ignoreAddressList;
    }

    @Override
    public ServerMessageListener getMessageListener() {
        return this.messageListener;
    }

    public void setMessageListener(ServerMessageListener messageListener) {
        Assert.requireNonNull(messageListener, "messageListener must not be null");
        this.messageListener = messageListener;
    }

    @Override
    public List<ServerStateChangeEventHandler> getStateChangeEventHandlers() {
        return this.stateChangeEventHandler;
    }

    public void addStateChangeEventHandler(ServerStateChangeEventHandler stateChangeEventHandler) {
        Assert.requireNonNull(stateChangeEventHandler, "stateChangeEventHandler must not be null");
        this.stateChangeEventHandler.add(stateChangeEventHandler);
    }

    @Override
    public ServerStreamChannelMessageListener getStreamMessageListener() {
        return this.serverStreamChannelMessageListener;
    }

    public void setServerStreamChannelMessageListener(ServerStreamChannelMessageListener serverStreamChannelMessageListener) {
        Assert.requireNonNull(serverStreamChannelMessageListener, "serverStreamChannelMessageListener must not be null");
        this.serverStreamChannelMessageListener = serverStreamChannelMessageListener;
    }

    @Override
    public Timer getRequestManagerTimer() {
        return this.requestManagerTimer;
    }

    @Override
    public ClusterOption getClusterOption() {
        return this.clusterOption;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PinpointServerAcceptor pinpointServerAcceptor = this;
        synchronized (pinpointServerAcceptor) {
            if (this.released) {
                return;
            }
            this.released = true;
        }
        this.healthCheckManager.stop();
        this.healthCheckTimer.stop();
        this.closePinpointServer();
        if (this.serverChannel != null) {
            ChannelFuture close = this.serverChannel.close();
            close.awaitUninterruptibly(3000L, TimeUnit.MILLISECONDS);
            this.serverChannel = null;
        }
        if (this.bootstrap != null) {
            this.bootstrap.releaseExternalResources();
            this.bootstrap = null;
        }
        this.requestManagerTimer.stop();
    }

    private void closePinpointServer() {
        for (Channel channel : this.channelGroup) {
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer == null) continue;
            pinpointServer.sendClosePacket();
        }
    }

    public List<PinpointSocket> getWritableSocketList() {
        ArrayList<PinpointSocket> pinpointServerList = new ArrayList<PinpointSocket>();
        for (Channel channel : this.channelGroup) {
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer == null || !pinpointServer.isEnableDuplexCommunication()) continue;
            pinpointServerList.add(pinpointServer);
        }
        return pinpointServerList;
    }

    static {
        LoggerFactorySetup.setupSlf4jLoggerFactory();
    }

    class PinpointServerChannelHandler
    extends SimpleChannelHandler {
        PinpointServerChannelHandler() {
        }

        @Override
        public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel channel = e.getChannel();
            PinpointServerAcceptor.this.logger.info("channelConnected channel:{}", (Object)channel);
            if (PinpointServerAcceptor.this.released) {
                PinpointServerAcceptor.this.logger.debug("already released. channel:{}", (Object)channel);
                if (channel.isWritable()) {
                    channel.write(new ServerClosePacket()).addListener(new ChannelFutureListener(){

                        @Override
                        public void operationComplete(ChannelFuture future) throws Exception {
                            future.getChannel().close();
                        }
                    });
                } else {
                    PinpointServerAcceptor.this.logger.error("[PinpointServerChannelHandler] channel isWritable is false! channel: " + channel);
                }
                return;
            }
            boolean isIgnore = PinpointServerAcceptor.this.isIgnoreAddress(channel);
            if (isIgnore) {
                PinpointServerAcceptor.this.logger.debug("channelConnected ignore address. channel:" + channel);
                return;
            }
            DefaultPinpointServer pinpointServer = PinpointServerAcceptor.this.createPinpointServer(channel);
            channel.setAttachment(pinpointServer);
            PinpointServerAcceptor.this.channelGroup.add(channel);
            pinpointServer.start();
            super.channelConnected(ctx, e);
        }

        @Override
        public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            boolean isIgnore;
            Channel channel = e.getChannel();
            PinpointServerAcceptor.this.logger.info("channel disconnected channel:{}", (Object)channel);
            if (PinpointServerAcceptor.this.released) {
                PinpointServerAcceptor.this.logger.debug("already released. channel:{}", (Object)channel);
                super.channelDisconnected(ctx, e);
            }
            if (isIgnore = PinpointServerAcceptor.this.isIgnoreAddress(channel)) {
                PinpointServerAcceptor.this.logger.debug("channelDisConnected ignore address. channel:" + channel);
                return;
            }
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer != null) {
                pinpointServer.stop(PinpointServerAcceptor.this.released);
            }
            super.channelDisconnected(ctx, e);
        }

        @Override
        public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
            Channel channel = e.getChannel();
            PinpointServerAcceptor.this.channelGroup.remove(channel);
            super.channelClosed(ctx, e);
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Channel channel = e.getChannel();
            DefaultPinpointServer pinpointServer = (DefaultPinpointServer)channel.getAttachment();
            if (pinpointServer != null) {
                Object message = e.getMessage();
                pinpointServer.messageReceived(message);
            }
            super.messageReceived(ctx, e);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            PinpointServerAcceptor.this.logger.warn("[WARN] Server Connection exception Caught (ServerAcceptor), dont worry, maybe health check, e:" + e);
        }
    }
}

