/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreateFailPacket;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannel;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.StreamChannelContext;
import java.util.concurrent.atomic.AtomicReference;

public class ClientStreamChannelContext
extends StreamChannelContext {
    private final ClientStreamChannel clientStreamChannel;
    private final ClientStreamChannelMessageListener clientStreamChannelMessageListener;
    private final AtomicReference<StreamCreateFailPacket> createFailPacketReference;

    public ClientStreamChannelContext(ClientStreamChannel clientStreamChannel, ClientStreamChannelMessageListener clientStreamChannelMessageListener) {
        Assert.requireNonNull(clientStreamChannel, "clientStreamChannel must not be null");
        Assert.requireNonNull(clientStreamChannelMessageListener, "clientStreamChannelMessageListener must not be null");
        this.clientStreamChannel = clientStreamChannel;
        this.clientStreamChannelMessageListener = clientStreamChannelMessageListener;
        this.createFailPacketReference = new AtomicReference();
    }

    @Override
    public ClientStreamChannel getStreamChannel() {
        return this.clientStreamChannel;
    }

    public ClientStreamChannelMessageListener getClientStreamChannelMessageListener() {
        return this.clientStreamChannelMessageListener;
    }

    public StreamCreateFailPacket getCreateFailPacket() {
        return this.createFailPacketReference.get();
    }

    public boolean setCreateFailPacket(StreamCreateFailPacket createFailPacket) {
        return this.createFailPacketReference.compareAndSet(null, createFailPacket);
    }
}

