/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.packet.stream.StreamClosePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCreatePacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamResponsePacket;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.ClientStreamChannelMessageListener;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelContext;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;

public class LoggingStreamChannelMessageListener {
    private static final PLogger LOGGER = PLoggerFactory.getLogger(LoggingStreamChannelMessageListener.class);
    public static final ServerStreamChannelMessageListener SERVER_LISTENER = new Server();
    public static final ClientStreamChannelMessageListener CLIENT_LISTENER = new Client();

    static class Client
    implements ClientStreamChannelMessageListener {
        Client() {
        }

        @Override
        public void handleStreamData(ClientStreamChannelContext streamChannelContext, StreamResponsePacket packet) {
            LOGGER.debug("handleStreamData StreamChannel:{}, Packet:{}", (Object)streamChannelContext, (Object)packet);
        }

        @Override
        public void handleStreamClose(ClientStreamChannelContext streamChannelContext, StreamClosePacket packet) {
            LOGGER.info("handleStreamClose StreamChannel:{}, Packet:{}", (Object)streamChannelContext, (Object)packet);
        }
    }

    static class Server
    implements ServerStreamChannelMessageListener {
        Server() {
        }

        @Override
        public StreamCode handleStreamCreate(ServerStreamChannelContext streamChannelContext, StreamCreatePacket packet) {
            LOGGER.info("handleStreamCreate StreamChannel:{}, Packet:{}", (Object)streamChannelContext, (Object)packet);
            return StreamCode.OK;
        }

        @Override
        public void handleStreamClose(ServerStreamChannelContext streamChannelContext, StreamClosePacket packet) {
            LOGGER.info("handleStreamClose StreamChannel:{}, Packet:{}", (Object)streamChannelContext, (Object)packet);
        }
    }
}

