/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.Channel;
import com.alibaba.csp.ahas.ext.arms.shaded.org.jboss.netty.channel.ChannelFuture;
import com.navercorp.pinpoint.common.arms.logging.PLogger;
import com.navercorp.pinpoint.common.arms.logging.PLoggerFactory;
import com.navercorp.pinpoint.rpc.PinpointSocketException;
import com.navercorp.pinpoint.rpc.packet.stream.StreamCode;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPingPacket;
import com.navercorp.pinpoint.rpc.packet.stream.StreamPongPacket;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannel;
import com.navercorp.pinpoint.rpc.stream.StreamChannelManager;
import com.navercorp.pinpoint.rpc.stream.StreamChannelState;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateChangeEventHandler;
import com.navercorp.pinpoint.rpc.stream.StreamChannelStateCode;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public abstract class StreamChannel {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final Channel channel;
    private final int streamChannelId;
    private final StreamChannelManager streamChannelManager;
    private final StreamChannelState state;
    private final CountDownLatch openLatch = new CountDownLatch(1);
    private List<StreamChannelStateChangeEventHandler> stateChangeEventHandlers = new CopyOnWriteArrayList<StreamChannelStateChangeEventHandler>();

    public StreamChannel(Channel channel, int streamId, StreamChannelManager streamChannelManager) {
        this.channel = channel;
        this.streamChannelId = streamId;
        this.streamChannelManager = streamChannelManager;
        this.state = new StreamChannelState();
    }

    public void addStateChangeEventHandler(StreamChannelStateChangeEventHandler stateChangeEventHandler) {
        this.stateChangeEventHandlers.add(stateChangeEventHandler);
    }

    public void setStateChangeEventHandler(List<StreamChannelStateChangeEventHandler> stateChangeEventHandlers) {
        this.stateChangeEventHandlers = stateChangeEventHandlers;
    }

    public List<StreamChannelStateChangeEventHandler> getStateChangeEventHandlers() {
        return new ArrayList<StreamChannelStateChangeEventHandler>(this.stateChangeEventHandlers);
    }

    boolean changeStateOpen() {
        return this.changeStateTo(StreamChannelStateCode.OPEN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeStateConnected() {
        try {
            boolean bl = this.changeStateTo(StreamChannelStateCode.CONNECTED);
            return bl;
        }
        finally {
            this.openLatch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean changeStateClose() {
        try {
            if (this.checkState(StreamChannelStateCode.CLOSED)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.changeStateTo(StreamChannelStateCode.CLOSED);
            return bl;
        }
        finally {
            this.openLatch.countDown();
        }
    }

    public boolean awaitOpen() {
        try {
            this.openLatch.await();
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public boolean awaitOpen(long timeoutMillis) {
        try {
            return this.openLatch.await(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public StreamChannelStateCode getCurrentState() {
        return this.state.getCurrentState();
    }

    public ChannelFuture sendPing(int requestId) {
        this.assertState(StreamChannelStateCode.CONNECTED);
        StreamPingPacket packet = new StreamPingPacket(this.streamChannelId, requestId);
        if (this.channel.isWritable()) {
            return this.channel.write(packet);
        }
        this.logger.error("[SteamChannel] sendPing channel isWritable is false! channel: " + this.channel);
        return null;
    }

    public ChannelFuture sendPong(int requestId) {
        this.assertState(StreamChannelStateCode.CONNECTED);
        StreamPongPacket packet = new StreamPongPacket(this.streamChannelId, requestId);
        if (this.channel.isWritable()) {
            return this.channel.write(packet);
        }
        this.logger.error("[SteamChannel] sendPong channel isWritable is false! channel: " + this.channel);
        return null;
    }

    public void close() {
        this.streamChannelManager.clearResourceAndSendClose(this.getStreamId(), StreamCode.STATE_CLOSED);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public int getStreamId() {
        return this.streamChannelId;
    }

    protected StreamChannelState getState() {
        return this.state;
    }

    public boolean isServer() {
        return this instanceof ServerStreamChannel;
    }

    void assertState(StreamChannelStateCode stateCode) {
        StreamChannelStateCode currentCode = this.getCurrentState();
        if (!this.checkState(currentCode, stateCode)) {
            throw new PinpointSocketException("expected:<" + (Object)((Object)stateCode) + "> but was:<" + (Object)((Object)currentCode) + ">;");
        }
    }

    boolean checkState(StreamChannelStateCode expectedCode) {
        return this.checkState(this.getCurrentState(), expectedCode);
    }

    boolean checkState(StreamChannelStateCode currentCode, StreamChannelStateCode expectedCode) {
        return currentCode == expectedCode;
    }

    protected boolean changeStateTo(StreamChannelStateCode nextState) {
        StreamChannelStateCode currentState = this.getCurrentState();
        boolean isChanged = this.state.to(currentState, nextState);
        if (!isChanged && this.getCurrentState() != StreamChannelStateCode.ILLEGAL_STATE) {
            this.changeStateTo(StreamChannelStateCode.ILLEGAL_STATE);
        }
        if (isChanged) {
            for (StreamChannelStateChangeEventHandler handler : this.stateChangeEventHandlers) {
                try {
                    handler.eventPerformed(this, nextState);
                }
                catch (Exception e) {
                    handler.exceptionCaught(this, nextState, e);
                }
            }
        }
        return isChanged;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[Channel:");
        sb.append(this.channel);
        sb.append(", StreamId:");
        sb.append(this.getStreamId());
        sb.append(", State:");
        sb.append((Object)this.getCurrentState());
        sb.append("].");
        return sb.toString();
    }
}

