/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.stream;

import com.navercorp.pinpoint.common.util.ArrayUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public enum StreamChannelStateCode {
    NEW(new StreamChannelStateCode[0]),
    OPEN(NEW),
    CONNECT_AWAIT(OPEN),
    CONNECT_ARRIVED(OPEN),
    CONNECTED(CONNECT_AWAIT, CONNECT_ARRIVED),
    CLOSED(CONNECT_AWAIT, CONNECT_ARRIVED, CONNECTED),
    ILLEGAL_STATE(NEW, OPEN, CONNECT_AWAIT, CONNECT_ARRIVED, CONNECTED, CLOSED);

    private final Set<StreamChannelStateCode> validBeforeStateSet;

    private StreamChannelStateCode(StreamChannelStateCode ... validBeforeStates) {
        this.validBeforeStateSet = this.asSet(validBeforeStates);
    }

    private Set<StreamChannelStateCode> asSet(StreamChannelStateCode[] validBeforeStates) {
        if (ArrayUtils.isEmpty(validBeforeStates)) {
            return Collections.emptySet();
        }
        HashSet<StreamChannelStateCode> temp = new HashSet<StreamChannelStateCode>();
        Collections.addAll(temp, validBeforeStates);
        return temp;
    }

    public boolean canChangeState(StreamChannelStateCode currentState) {
        return this.validBeforeStateSet.contains((Object)currentState);
    }
}

