/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.thrift.io.BufferOverflowException;
import com.navercorp.pinpoint.thrift.io.ResettableOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

public class ByteBufferOutputStream
extends OutputStream
implements ResettableOutputStream {
    private final ByteBuffer byteBuffer;

    public ByteBufferOutputStream(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkWriteAvailable(1);
        this.byteBuffer.put((byte)b);
    }

    @Override
    public void write(byte[] byteArray, int offset, int length) throws IOException {
        this.checkWriteAvailable(length);
        this.byteBuffer.put(byteArray, offset, length);
    }

    private void checkWriteAvailable(int size) {
        if (this.byteBuffer.remaining() >= size) {
            return;
        }
        this.byteBuffer.limit(this.byteBuffer.capacity());
        if (this.byteBuffer.remaining() < size) {
            throw new BufferOverflowException("write failed remaining-size:" + this.byteBuffer.remaining() + ", input-size:" + size + ".");
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        this.deallocate(this.byteBuffer);
    }

    private void deallocate(ByteBuffer byteBuffer) {
        Cleaner cleaner;
        if (byteBuffer == null) {
            return;
        }
        if (byteBuffer instanceof DirectBuffer && (cleaner = ((DirectBuffer)((Object)byteBuffer)).cleaner()) != null) {
            cleaner.clean();
        }
    }

    public ByteBuffer getByteBuffer() {
        this.byteBuffer.flip();
        return this.byteBuffer;
    }

    public void clear() {
        this.byteBuffer.clear();
    }

    @Override
    public void mark() {
        this.byteBuffer.mark();
    }

    @Override
    public void resetToMarkIndex() {
        this.byteBuffer.reset();
    }
}

