/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TCompactProtocol;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocolFactory;
import com.navercorp.pinpoint.thrift.io.ChunkHeaderBufferedTBaseSerializer;
import com.navercorp.pinpoint.thrift.io.DefaultTBaseLocator;
import com.navercorp.pinpoint.thrift.io.PinpointByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.SerializerFactory;
import com.navercorp.pinpoint.thrift.io.TBaseLocator;
import com.navercorp.pinpoint.thrift.io.UnsafeByteArrayOutputStream;

public final class ChunkHeaderBufferedTBaseSerializerFactory
implements SerializerFactory<ChunkHeaderBufferedTBaseSerializer> {
    private static final boolean DEFAULT_SAFE_GUARANTEED = false;
    private static final int DEFAULT_STREAM_SIZE = 8192;
    private static final boolean DEFAULT_AUTO_EXPAND = true;
    private static final TBaseLocator DEFAULT_TBASE_LOCATOR = new DefaultTBaseLocator();
    private static final TProtocolFactory DEFAULT_PROTOCOL_FACTORY = new TCompactProtocol.Factory();
    private final boolean safetyGuaranteed;
    private final int outputStreamSize;
    private final boolean autoExpand;
    private final TProtocolFactory protocolFactory;
    private final TBaseLocator locator;

    public ChunkHeaderBufferedTBaseSerializerFactory() {
        this(false, 8192, DEFAULT_PROTOCOL_FACTORY, DEFAULT_TBASE_LOCATOR);
    }

    public ChunkHeaderBufferedTBaseSerializerFactory(boolean safetyGuaranteed, int outputStreamSize, TProtocolFactory protocolFactory, TBaseLocator locator) {
        this(safetyGuaranteed, outputStreamSize, true, protocolFactory, locator);
    }

    public ChunkHeaderBufferedTBaseSerializerFactory(boolean safetyGuaranteed, int outputStreamSize, boolean autoExpand, TProtocolFactory protocolFactory, TBaseLocator locator) {
        this.safetyGuaranteed = safetyGuaranteed;
        this.outputStreamSize = outputStreamSize;
        this.autoExpand = autoExpand;
        this.protocolFactory = protocolFactory;
        this.locator = locator;
    }

    public boolean isSafetyGuaranteed() {
        return this.safetyGuaranteed;
    }

    public int getOutputStreamSize() {
        return this.outputStreamSize;
    }

    public TProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    public TBaseLocator getLocator() {
        return this.locator;
    }

    @Override
    public ChunkHeaderBufferedTBaseSerializer createSerializer() {
        ResettableByteArrayOutputStream baos = null;
        baos = this.safetyGuaranteed ? new PinpointByteArrayOutputStream(this.outputStreamSize, this.autoExpand) : new UnsafeByteArrayOutputStream(this.outputStreamSize, this.autoExpand);
        return new ChunkHeaderBufferedTBaseSerializer(baos, this.protocolFactory, this.locator);
    }

    @Override
    public boolean isSupport(Object target) {
        if (target instanceof TBase) {
            return this.locator.isSupport(target.getClass());
        }
        return false;
    }
}

