/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocol;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocolFactory;
import com.navercorp.pinpoint.thrift.io.ByteArrayOutput;
import com.navercorp.pinpoint.thrift.io.ByteArrayOutputStreamTransport;
import com.navercorp.pinpoint.thrift.io.TBaseStreamNode;
import com.navercorp.pinpoint.thrift.io.UnsafeByteArrayOutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class TBaseStream {
    private final TProtocolFactory protocolFactory;
    private final ByteArrayOutputStreamTransport transport;
    private final LinkedList<TBaseStreamNode> nodes = new LinkedList();

    public TBaseStream(TProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
        this.transport = new ByteArrayOutputStreamTransport(new UnsafeByteArrayOutputStream());
    }

    public void write(List<TBase<?, ?>> list) throws TException {
        for (TBase<?, ?> base : list) {
            this.write(base);
        }
    }

    public void write(TBase<?, ?> base) throws TException {
        TBaseStreamNode node = new TBaseStreamNode(this.transport);
        node.setClassName(base.getClass().getName());
        node.setBeginPosition(this.transport.getBufferPosition());
        TProtocol protocol = this.protocolFactory.getProtocol(this.transport);
        base.write(protocol);
        node.setEndPosition(this.transport.getBufferPosition());
        this.nodes.add(node);
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public int size() {
        int size = 0;
        for (TBaseStreamNode node : this.nodes) {
            size += node.size();
        }
        return size;
    }

    public List<ByteArrayOutput> splitAll() {
        ArrayList<ByteArrayOutput> list = new ArrayList<ByteArrayOutput>();
        TBaseStreamNode node = null;
        while ((node = this.nodes.peek()) != null) {
            list.add(node);
            this.nodes.poll();
        }
        return list;
    }

    public List<ByteArrayOutput> split(int maxSize) {
        ArrayList<ByteArrayOutput> list = new ArrayList<ByteArrayOutput>();
        int currentSize = 0;
        TBaseStreamNode node = null;
        while ((node = this.nodes.peek()) != null) {
            if (node.size() > maxSize) {
                if (!list.isEmpty()) break;
                list.add(node);
                this.nodes.poll();
                break;
            }
            if (currentSize + node.size() > maxSize) break;
            currentSize += node.size();
            list.add(node);
            this.nodes.poll();
        }
        return list;
    }

    public void clear() throws TException {
        this.nodes.clear();
        this.transport.flush();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("nodes=").append(this.nodes).append(", ");
        sb.append("transport=").append(this.transport);
        sb.append("}");
        return sb.toString();
    }
}

