/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TBase;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.navercorp.pinpoint.thrift.io.Header;
import com.navercorp.pinpoint.thrift.io.TBaseLocator;
import com.navercorp.pinpoint.thrift.io.TCommandType;
import com.navercorp.pinpoint.thrift.io.TCommandTypeVersion;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class TCommandRegistry
implements TBaseLocator {
    private final ConcurrentHashMap<Short, TCommandType> commandTBaseRepository = new ConcurrentHashMap();

    public TCommandRegistry(TCommandTypeVersion version) {
        this(version.getSupportCommandList());
    }

    public TCommandRegistry(List<TCommandType> supportCommandList) {
        for (TCommandType type : supportCommandList) {
            this.commandTBaseRepository.put(type.getCode(), type);
        }
    }

    @Override
    public TBase<?, ?> tBaseLookup(short type) throws TException {
        TCommandType commandTBaseType = this.commandTBaseRepository.get(type);
        if (commandTBaseType == null) {
            throw new TException("Unsupported type:" + type);
        }
        return commandTBaseType.newObject();
    }

    @Override
    public Header headerLookup(TBase<?, ?> tbase) throws TException {
        if (tbase == null) {
            throw new IllegalArgumentException("tbase must not be null");
        }
        Collection<TCommandType> commandTBaseList = this.commandTBaseRepository.values();
        for (TCommandType commandTBase : commandTBaseList) {
            if (!commandTBase.isInstanceOf(tbase)) continue;
            return commandTBase.getHeader();
        }
        throw new TException("Unsupported Type" + tbase.getClass());
    }

    @Override
    public boolean isSupport(short type) {
        TCommandType commandTBaseType = this.commandTBaseRepository.get(type);
        return commandTBaseType != null;
    }

    @Override
    public boolean isSupport(Class<? extends TBase> clazz) {
        Collection<TCommandType> commandTBaseList = this.commandTBaseRepository.values();
        for (TCommandType commandTBase : commandTBaseList) {
            if (!commandTBase.getClazz().equals(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Header getChunkHeader() {
        return null;
    }

    @Override
    public boolean isChunkHeader(short type) {
        return false;
    }
}

