/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.TException;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TField;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TList;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TMap;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TMessage;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TProtocol;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TSet;
import com.alibaba.csp.ahas.ext.arms.shaded.org.apache.thrift.protocol.TStruct;
import com.navercorp.pinpoint.thrift.io.ByteArrayOutput;
import com.navercorp.pinpoint.thrift.io.ByteArrayOutputStreamTransport;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TReplaceListProtocol
extends TProtocol {
    private boolean writeFieldBegin = false;
    private int writeListDepth = 0;
    private Map<String, List<ByteArrayOutput>> replaceFields = new HashMap<String, List<ByteArrayOutput>>();
    private TField currentField = null;
    private TProtocol protocol;

    public TReplaceListProtocol(TProtocol protocol) {
        super(protocol.getTransport());
        this.protocol = protocol;
    }

    public void addReplaceField(String fieldName, List<ByteArrayOutput> outputs) {
        if (fieldName == null) {
            throw new IllegalArgumentException("field name must not be null");
        }
        if (outputs == null || outputs.isEmpty()) {
            throw new IllegalArgumentException("stream nodes must not be empty");
        }
        this.replaceFields.put(fieldName, outputs);
    }

    @Override
    public void writeFieldBegin(TField field) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeFieldBegin(field);
            if (this.replaceFields.containsKey(field.name)) {
                this.writeFieldBegin = true;
                this.currentField = field;
            }
        }
    }

    @Override
    public void writeFieldEnd() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeFieldEnd();
        } else if (this.writeListDepth == 0) {
            this.writeFieldBegin = false;
            this.currentField = null;
        }
    }

    @Override
    public void writeListBegin(TList list) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeListBegin(list);
            return;
        }
        if (this.writeListDepth == 0 && this.currentField != null) {
            List<ByteArrayOutput> outputs = this.replaceFields.get(this.currentField.name);
            if (outputs == null) {
                throw new TException("not found replace field - " + this.currentField.name);
            }
            TList replaceList = new TList(list.elemType, outputs.size());
            this.protocol.writeListBegin(replaceList);
            for (ByteArrayOutput output : outputs) {
                try {
                    ByteArrayOutputStream out = ((ByteArrayOutputStreamTransport)this.getTransport()).getByteArrayOutputStream();
                    output.writeTo(out);
                }
                catch (IOException e) {
                    throw new TException(e);
                }
            }
        }
        ++this.writeListDepth;
    }

    @Override
    public void writeListEnd() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeListEnd();
        } else {
            --this.writeListDepth;
        }
    }

    @Override
    public void reset() {
        this.protocol.reset();
    }

    @Override
    public void writeMessageBegin(TMessage message) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeMessageBegin(message);
        }
    }

    @Override
    public void writeMessageEnd() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeMessageEnd();
        }
    }

    @Override
    public void writeStructBegin(TStruct struct) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeStructBegin(struct);
        }
    }

    @Override
    public void writeStructEnd() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeStructEnd();
        }
    }

    @Override
    public void writeFieldStop() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeFieldStop();
        }
    }

    @Override
    public void writeMapBegin(TMap map) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeMapBegin(map);
        }
    }

    @Override
    public void writeMapEnd() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeMapEnd();
        }
    }

    @Override
    public void writeSetBegin(TSet set) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeSetBegin(set);
        }
    }

    @Override
    public void writeSetEnd() throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeSetEnd();
        }
    }

    @Override
    public void writeBool(boolean b) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeBool(b);
        }
    }

    @Override
    public void writeByte(byte b) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeByte(b);
        }
    }

    @Override
    public void writeI16(short i16) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeI16(i16);
        }
    }

    @Override
    public void writeI32(int i32) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeI32(i32);
        }
    }

    @Override
    public void writeI64(long i64) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeI64(i64);
        }
    }

    @Override
    public void writeDouble(double dub) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeDouble(dub);
        }
    }

    @Override
    public void writeString(String str) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeString(str);
        }
    }

    @Override
    public void writeBinary(ByteBuffer bin) throws TException {
        if (!this.writeFieldBegin) {
            this.protocol.writeBinary(bin);
        }
    }

    @Override
    public ByteBuffer readBinary() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public boolean readBool() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public byte readByte() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public double readDouble() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public TField readFieldBegin() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public void readFieldEnd() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public short readI16() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public int readI32() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public long readI64() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public TList readListBegin() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public void readListEnd() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public TMap readMapBegin() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public void readMapEnd() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public TMessage readMessageBegin() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public void readMessageEnd() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public TSet readSetBegin() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public void readSetEnd() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public String readString() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public TStruct readStructBegin() throws TException {
        throw new TException("unsupported operation");
    }

    @Override
    public void readStructEnd() throws TException {
        throw new TException("unsupported operation");
    }
}

