/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.dubbo3;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.dubbo3.BaseSentinelDubboFilter;
import com.alibaba.csp.sentinel.adapter.dubbo3.DubboUtils;
import com.alibaba.csp.sentinel.adapter.dubbo3.config.DubboAdapterGlobalConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcException;

@Activate(group={"provider"})
public class SentinelDubboProviderFilter
extends BaseSentinelDubboFilter
implements Filter {
    public SentinelDubboProviderFilter() {
        RecordLog.info((String)"Sentinel Apache Dubbo3 provider filter initialized", (Object[])new Object[0]);
    }

    @Override
    String getMethodName(Invoker invoker, Invocation invocation, String prefix) {
        return DubboUtils.getMethodResourceName(invoker, invocation, prefix);
    }

    @Override
    String getInterfaceName(Invoker invoker, String prefix) {
        return DubboUtils.getInterfaceName(invoker, prefix);
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        String origin = DubboAdapterGlobalConfig.getOriginParser().parse(invoker, invocation);
        if (null == origin) {
            origin = "";
        }
        Entry interfaceEntry = null;
        Entry methodEntry = null;
        String prefix = DubboAdapterGlobalConfig.getDubboProviderResNamePrefixKey();
        String interfaceResourceName = this.getInterfaceName(invoker, prefix);
        String methodResourceName = this.getMethodName(invoker, invocation, prefix);
        try {
            ContextUtil.enter((String)methodResourceName, (String)origin);
            interfaceEntry = SphU.entry((String)interfaceResourceName, (int)2, (EntryType)EntryType.IN);
            methodEntry = SphU.entry((String)methodResourceName, (int)2, (EntryType)EntryType.IN, (Object[])invocation.getArguments());
            Result result = invoker.invoke(invocation);
            if (result.hasException()) {
                Tracer.traceEntry((Throwable)result.getException(), (Entry)interfaceEntry);
                Tracer.traceEntry((Throwable)result.getException(), (Entry)methodEntry);
            }
            Result result2 = result;
            return result2;
        }
        catch (BlockException e) {
            Result result = DubboAdapterGlobalConfig.getProviderFallback().handle(invoker, invocation, e);
            return result;
        }
        catch (RpcException e) {
            Tracer.traceEntry((Throwable)e, interfaceEntry);
            Tracer.traceEntry((Throwable)e, methodEntry);
            throw e;
        }
        finally {
            if (methodEntry != null) {
                methodEntry.exit(1, invocation.getArguments());
            }
            if (interfaceEntry != null) {
                interfaceEntry.exit();
            }
            ContextUtil.exit();
        }
    }
}

