/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.gateway.common.rule;

import com.alibaba.csp.sentinel.adapter.gateway.common.param.GatewayRegexCache;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayFlowRule;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayParamFlowItem;
import com.alibaba.csp.sentinel.adapter.gateway.common.rule.GatewayRuleConverter;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.property.DynamicSentinelProperty;
import com.alibaba.csp.sentinel.property.PropertyListener;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRuleUtil;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetric;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParameterMetricStorage;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class GatewayRuleManager {
    private static final Map<String, Set<GatewayFlowRule>> GATEWAY_RULE_MAP = new ConcurrentHashMap<String, Set<GatewayFlowRule>>();
    private static final Map<String, List<ParamFlowRule>> CONVERTED_PARAM_RULE_MAP = new ConcurrentHashMap<String, List<ParamFlowRule>>();
    private static final GatewayRulePropertyListener LISTENER = new GatewayRulePropertyListener();
    private static final Set<Integer> FIELD_REQUIRED_SET = new HashSet<Integer>(Arrays.asList(3, 2, 4));
    private static SentinelProperty<Set<GatewayFlowRule>> currentProperty = new DynamicSentinelProperty();

    private GatewayRuleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register2Property(SentinelProperty<Set<GatewayFlowRule>> property) {
        AssertUtil.notNull(property, (String)"property cannot be null");
        GatewayRulePropertyListener gatewayRulePropertyListener = LISTENER;
        synchronized (gatewayRulePropertyListener) {
            RecordLog.info((String)"[GatewayRuleManager] Registering new property to gateway flow rule manager", (Object[])new Object[0]);
            currentProperty.removeListener((PropertyListener)LISTENER);
            property.addListener((PropertyListener)LISTENER);
            currentProperty = property;
        }
    }

    public static boolean loadRules(Set<GatewayFlowRule> rules) {
        return currentProperty.updateValue(rules);
    }

    public static Set<GatewayFlowRule> getRules() {
        HashSet<GatewayFlowRule> rules = new HashSet<GatewayFlowRule>();
        for (Set<GatewayFlowRule> ruleSet : GATEWAY_RULE_MAP.values()) {
            rules.addAll(ruleSet);
        }
        return rules;
    }

    public static Set<GatewayFlowRule> getRulesForResource(String resourceName) {
        if (StringUtil.isBlank((String)resourceName)) {
            return new HashSet<GatewayFlowRule>();
        }
        Set<GatewayFlowRule> set = GATEWAY_RULE_MAP.get(resourceName);
        if (set == null) {
            return new HashSet<GatewayFlowRule>();
        }
        return new HashSet<GatewayFlowRule>(set);
    }

    public static List<ParamFlowRule> getConvertedParamRules(String resourceName) {
        if (StringUtil.isBlank((String)resourceName)) {
            return new ArrayList<ParamFlowRule>();
        }
        return CONVERTED_PARAM_RULE_MAP.get(resourceName);
    }

    public static boolean isValidRule(GatewayFlowRule rule) {
        if (rule == null || StringUtil.isBlank((String)rule.getResource()) || rule.getResourceMode() < 0 || rule.getGrade() < 0 || rule.getCount() < 0.0 || rule.getBurst() < 0 || rule.getControlBehavior() < 0) {
            return false;
        }
        if (rule.getGrade() == 2 && rule.getMaxQueueingTimeoutMs() < 0) {
            return false;
        }
        if (rule.getIntervalSec() <= 0L) {
            return false;
        }
        GatewayParamFlowItem item = rule.getParamItem();
        if (item != null) {
            return GatewayRuleManager.isValidParamItem(item);
        }
        return true;
    }

    static boolean isValidParamItem(GatewayParamFlowItem item) {
        if (item.getParseStrategy() < 0) {
            return false;
        }
        if (FIELD_REQUIRED_SET.contains(item.getParseStrategy()) && StringUtil.isBlank((String)item.getFieldName())) {
            return false;
        }
        return StringUtil.isEmpty((String)item.getPattern()) || item.getMatchStrategy() >= 0;
    }

    static {
        currentProperty.addListener((PropertyListener)LISTENER);
    }

    private static final class GatewayRulePropertyListener
    implements PropertyListener<Set<GatewayFlowRule>> {
        private GatewayRulePropertyListener() {
        }

        public void configUpdate(Set<GatewayFlowRule> conf) {
            this.applyGatewayRuleInternal(conf);
            RecordLog.info((String)"[GatewayRuleManager] Gateway flow rules received: {}", (Object[])new Object[]{GATEWAY_RULE_MAP});
        }

        public void configLoad(Set<GatewayFlowRule> conf) {
            this.applyGatewayRuleInternal(conf);
            RecordLog.info((String)"[GatewayRuleManager] Gateway flow rules loaded: {}", (Object[])new Object[]{GATEWAY_RULE_MAP});
        }

        private int getIdxInternal(Map<String, Integer> idxMap, String resourceName) {
            if (!idxMap.containsKey(resourceName)) {
                idxMap.put(resourceName, 0);
            }
            return idxMap.get(resourceName);
        }

        private void cacheRegexPattern(GatewayParamFlowItem item) {
            String pattern = item.getPattern();
            if (StringUtil.isNotEmpty((String)pattern) && item.getMatchStrategy() == 2 && GatewayRegexCache.getRegexPattern(pattern) == null) {
                GatewayRegexCache.addRegexPattern(pattern);
            }
        }

        private synchronized void applyGatewayRuleInternal(Set<GatewayFlowRule> conf) {
            if (conf == null || conf.isEmpty()) {
                this.applyToConvertedParamMap(new HashSet<ParamFlowRule>());
                GATEWAY_RULE_MAP.clear();
                return;
            }
            ConcurrentHashMap<String, HashSet<GatewayFlowRule>> gatewayRuleMap = new ConcurrentHashMap<String, HashSet<GatewayFlowRule>>();
            HashMap<String, Integer> idxMap = new HashMap<String, Integer>();
            HashSet<ParamFlowRule> paramFlowRules = new HashSet<ParamFlowRule>();
            HashMap<String, ArrayList<GatewayFlowRule>> noParamMap = new HashMap<String, ArrayList<GatewayFlowRule>>();
            for (GatewayFlowRule gatewayFlowRule : conf) {
                if (!GatewayRuleManager.isValidRule(gatewayFlowRule)) {
                    RecordLog.warn((String)("[GatewayRuleManager] Ignoring invalid rule when loading new rules: " + gatewayFlowRule), (Object[])new Object[0]);
                    continue;
                }
                String resourceName = gatewayFlowRule.getResource();
                if (gatewayFlowRule.getParamItem() == null) {
                    ArrayList<GatewayFlowRule> noParamList = (ArrayList<GatewayFlowRule>)noParamMap.get(resourceName);
                    if (noParamList == null) {
                        noParamList = new ArrayList<GatewayFlowRule>();
                        noParamMap.put(resourceName, noParamList);
                    }
                    noParamList.add(gatewayFlowRule);
                } else {
                    int idx = this.getIdxInternal(idxMap, resourceName);
                    if (paramFlowRules.add(GatewayRuleConverter.applyToParamRule(gatewayFlowRule, idx))) {
                        idxMap.put(gatewayFlowRule.getResource(), idx + 1);
                    }
                    this.cacheRegexPattern(gatewayFlowRule.getParamItem());
                }
                HashSet<GatewayFlowRule> ruleSet = (HashSet<GatewayFlowRule>)gatewayRuleMap.get(resourceName);
                if (ruleSet == null) {
                    ruleSet = new HashSet<GatewayFlowRule>();
                    gatewayRuleMap.put(resourceName, ruleSet);
                }
                ruleSet.add(gatewayFlowRule);
            }
            for (Map.Entry entry : noParamMap.entrySet()) {
                List rules = (List)entry.getValue();
                if (rules == null || rules.isEmpty()) continue;
                for (GatewayFlowRule rule : rules) {
                    int idx = this.getIdxInternal(idxMap, (String)entry.getKey());
                    paramFlowRules.add(GatewayRuleConverter.applyNonParamToParamRule(rule, idx));
                }
            }
            this.applyToConvertedParamMap(paramFlowRules);
            GATEWAY_RULE_MAP.clear();
            GATEWAY_RULE_MAP.putAll(gatewayRuleMap);
        }

        private void applyToConvertedParamMap(Set<ParamFlowRule> paramFlowRules) {
            Map newRuleMap = ParamFlowRuleUtil.buildParamRuleMap(new ArrayList<ParamFlowRule>(paramFlowRules));
            if (newRuleMap == null || newRuleMap.isEmpty()) {
                for (String resource : CONVERTED_PARAM_RULE_MAP.keySet()) {
                    ParameterMetricStorage.clearParamMetricForResource((String)resource);
                }
                RecordLog.info((String)"[GatewayRuleManager] No gateway rules, clearing parameter metrics of previous rules", (Object[])new Object[0]);
                CONVERTED_PARAM_RULE_MAP.clear();
                return;
            }
            for (Map.Entry entry : CONVERTED_PARAM_RULE_MAP.entrySet()) {
                String resource = (String)entry.getKey();
                if (!newRuleMap.containsKey(resource)) {
                    ParameterMetricStorage.clearParamMetricForResource((String)resource);
                    continue;
                }
                List newRuleList = (List)newRuleMap.get(resource);
                ArrayList oldRuleList = new ArrayList((Collection)entry.getValue());
                oldRuleList.removeAll(newRuleList);
                for (ParamFlowRule rule : oldRuleList) {
                    ParameterMetric metric = ParameterMetricStorage.getParamMetricForResource((String)resource);
                    if (null == metric) continue;
                    metric.clearForRule(rule);
                }
            }
            CONVERTED_PARAM_RULE_MAP.clear();
            CONVERTED_PARAM_RULE_MAP.putAll(newRuleMap);
            RecordLog.info((String)"[GatewayRuleManager] Converted internal param rules: {}", (Object[])new Object[]{CONVERTED_PARAM_RULE_MAP});
        }
    }
}

