/*
 * Copyright 1999-2019 Alibaba Group Holding Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.alibaba.csp.sentinel.datasource.nacos;

import java.util.Properties;

import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.nacos.api.PropertyKeyConst;

/**
 * @author Eric Zhao
 */
public class NacosDataSourceFactory {

    private final Properties properties;

    public NacosDataSourceFactory(String serverAddr) {
        this(buildProperties(serverAddr));
    }

    public NacosDataSourceFactory(Properties properties) {
        AssertUtil.notNull(properties, "Nacos properties cannot be null");
        this.properties = properties;
    }

    private void initClient() {

    }

    private static Properties buildProperties(String serverAddr) {
        AssertUtil.assertNotBlank(serverAddr, "serverAddr cannot be blank");
        Properties properties = new Properties();
        properties.setProperty(PropertyKeyConst.SERVER_ADDR, serverAddr);
        return properties;
    }
}
