/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.datasource.redis.config;

import com.alibaba.csp.sentinel.util.AssertUtil;

public class RedisHostAndPort {
    private static final int NO_PORT = -1;
    public final String host;
    public final int port;

    private RedisHostAndPort(String host, int port) {
        AssertUtil.notNull((Object)host, (String)"host must not be null");
        this.host = host;
        this.port = port;
    }

    public static RedisHostAndPort of(String host, int port) {
        AssertUtil.isTrue((boolean)RedisHostAndPort.isValidPort(port), (String)String.format("Port out of range: %s", port));
        return new RedisHostAndPort(host, port);
    }

    public boolean hasPort() {
        return this.port != -1;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        if (!this.hasPort()) {
            throw new IllegalStateException("No port present.");
        }
        return this.port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RedisHostAndPort)) {
            return false;
        }
        RedisHostAndPort that = (RedisHostAndPort)o;
        return this.port == that.port && (this.host != null ? this.host.equals(that.host) : that.host == null);
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + this.port;
        return result;
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.host);
        if (this.hasPort()) {
            sb.append(':').append(this.port);
        }
        return sb.toString();
    }
}

