/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.command.handler;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.command.annotation.CommandMapping;
import com.alibaba.csp.sentinel.node.ClusterNode;
import com.alibaba.csp.sentinel.slotchain.ResourceWrapper;
import com.alibaba.csp.sentinel.slots.clusterbuilder.ClusterBuilderSlot;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.util.Map;

@CommandMapping(name="cnode", desc="get clusterNode metrics by id, request param: id={resourceName}")
public class FetchClusterNodeHumanCommandHandler
implements CommandHandler<String> {
    private static final String FORMAT = "%-4s%-80s%-10s%-10s%-10s%-11s%-9s%-6s%-10s%-11s%-9s%-11s";
    private static final int MAX_LEN = 79;

    @Override
    public CommandResponse<String> handle(CommandRequest request) {
        String name = request.getParam("id");
        if (StringUtil.isEmpty((String)name)) {
            return CommandResponse.ofFailure(new IllegalArgumentException("Invalid parameter: empty clusterNode name"));
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int nameLength = 0;
        for (Map.Entry e : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            if (!((ResourceWrapper)e.getKey()).getName().contains(name)) continue;
            int l = ((ResourceWrapper)e.getKey()).getShowName().length();
            if (l > nameLength) {
                nameLength = l;
            }
            if (++i != 30) continue;
            break;
        }
        nameLength = nameLength > 79 ? 79 : nameLength;
        String format = FORMAT.replaceAll("80", String.valueOf(nameLength + 1));
        sb.append(String.format(format, "idx", "id", "thread", "pass", "blocked", "success", "total", "aRt", "1m-pass", "1m-block", "1m-all", "exception")).append("\n");
        for (Map.Entry e : ClusterBuilderSlot.getClusterNodeMap().entrySet()) {
            if (!((ResourceWrapper)e.getKey()).getName().contains(name)) continue;
            ClusterNode node = (ClusterNode)e.getValue();
            String id = ((ResourceWrapper)e.getKey()).getShowName();
            int lenNum = (int)Math.ceil((double)id.length() / (double)nameLength) - 1;
            sb.append(String.format(format, i + 1, lenNum == 0 ? id : id.substring(0, nameLength), node.curThreadNum(), node.passQps(), node.blockQps(), node.successQps(), node.totalQps(), node.avgRt(), node.totalRequest() - node.blockRequest(), node.blockRequest(), node.totalRequest(), node.exceptionQps())).append("\n");
            for (int j = 1; j <= lenNum; ++j) {
                int start = nameLength * j;
                int end = j == lenNum ? id.length() : nameLength * (j + 1);
                sb.append(String.format(format, "", id.substring(start, end), "", "", "", "", "", "", "", "", "", "", "", "")).append("\n");
            }
            if (++i != 30) continue;
            break;
        }
        return CommandResponse.ofSuccess(sb.toString());
    }
}

