/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.heartbeat.client;

import com.alibaba.csp.sentinel.config.SentinelConfig;
import java.nio.charset.Charset;
import java.util.Map;

public class SimpleHttpResponse {
    private Charset charset = Charset.forName(SentinelConfig.charset());
    private String statusLine;
    private int statusCode;
    private Map<String, String> headers;
    private byte[] body;

    public SimpleHttpResponse(String statusLine, Map<String, String> headers) {
        this.statusLine = statusLine;
        this.headers = headers;
    }

    public SimpleHttpResponse(String statusLine, Map<String, String> headers, byte[] body) {
        this.statusLine = statusLine;
        this.headers = headers;
        this.body = body;
    }

    private void parseCharset() {
        String contentType = this.getHeader("Content-Type");
        for (String str : contentType.split(" ")) {
            if (!str.toLowerCase().startsWith("charset=")) continue;
            this.charset = Charset.forName(str.split("=")[1]);
        }
    }

    private void parseCode() {
        this.statusCode = Integer.parseInt(this.statusLine.split(" ")[1]);
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getStatusLine() {
        return this.statusLine;
    }

    public Integer getStatusCode() {
        if (this.statusCode == 0) {
            this.parseCode();
        }
        return this.statusCode;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        String value = this.headers.get(key);
        if (value != null) {
            return value;
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            if (!entry.getKey().equalsIgnoreCase(key)) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getBodyAsString() {
        this.parseCharset();
        return new String(this.body, this.charset);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.statusLine).append("\r\n");
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            buf.append(entry.getKey()).append(": ").append(entry.getValue()).append("\r\n");
        }
        buf.append("\r\n");
        buf.append(this.getBodyAsString());
        return buf.toString();
    }
}

