/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.transport.command.http;

import com.alibaba.csp.sentinel.command.CommandHandler;
import com.alibaba.csp.sentinel.command.CommandRequest;
import com.alibaba.csp.sentinel.command.CommandResponse;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.log.CommandCenterLog;
import com.alibaba.csp.sentinel.transport.command.SimpleHttpCommandCenter;
import com.alibaba.csp.sentinel.transport.util.HttpCommandUtils;
import com.alibaba.csp.sentinel.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.Charset;

public class HttpEventTask
implements Runnable {
    private final Socket socket;
    private boolean writtenHead = false;
    private static final String SERVER_ERROR_MESSAGE = "Command server error";

    public HttpEventTask(Socket socket) {
        this.socket = socket;
    }

    public void close() throws Exception {
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String commandName;
        CommandRequest request;
        String line;
        OutputStream outputStream;
        long start;
        PrintWriter printWriter;
        BufferedReader in;
        block22: {
            if (this.socket == null) {
                return;
            }
            in = null;
            printWriter = null;
            start = System.currentTimeMillis();
            in = new BufferedReader(new InputStreamReader(this.socket.getInputStream(), SentinelConfig.charset()));
            outputStream = this.socket.getOutputStream();
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, Charset.forName(SentinelConfig.charset())));
            line = in.readLine();
            CommandCenterLog.info((String)("[SimpleHttpCommandCenter] Socket income: " + line + ", addr: " + this.socket.getInetAddress()), (Object[])new Object[0]);
            request = this.parseRequest(line);
            if (line.length() > 4 && StringUtil.equalsIgnoreCase((CharSequence)"POST", (CharSequence)line.substring(0, 4))) {
                String bodyLine = null;
                boolean bodyNext = false;
                boolean supported = false;
                int maxLength = 8192;
                while (true) {
                    if (bodyNext) {
                        if (!supported) break;
                        char[] bodyBytes = new char[maxLength];
                        int read = in.read(bodyBytes);
                        String postData = new String(bodyBytes, 0, read);
                        this.parseParams(postData, request);
                        break;
                    }
                    bodyLine = in.readLine();
                    if (bodyLine == null) break;
                    if (StringUtil.isEmpty((String)bodyLine)) {
                        bodyNext = true;
                        continue;
                    }
                    int index = bodyLine.indexOf(":");
                    if (index < 1) continue;
                    String headerName = bodyLine.substring(0, index);
                    String header = bodyLine.substring(index + 1).trim();
                    if (StringUtil.equalsIgnoreCase((CharSequence)"content-type", (CharSequence)headerName)) {
                        int idx = header.indexOf(";");
                        if (idx > 0) {
                            header = header.substring(0, idx).trim();
                        }
                        if (StringUtil.equals((String)"application/x-www-form-urlencoded", (String)header)) {
                            supported = true;
                            continue;
                        }
                        CommandCenterLog.warn((String)("Content-Type not supported: " + header), (Object[])new Object[0]);
                        break;
                    }
                    if (!StringUtil.equalsIgnoreCase((CharSequence)"content-length", (CharSequence)headerName)) continue;
                    try {
                        int len = Integer.parseInt(header);
                        if (len <= 0) continue;
                        maxLength = len;
                    }
                    catch (Exception e) {
                        CommandCenterLog.warn((String)("Malformed content-length header value: " + header), (Object[])new Object[0]);
                    }
                }
            }
            if (!StringUtil.isBlank((String)(commandName = HttpCommandUtils.getTarget((CommandRequest)request)))) break block22;
            this.badRequest(printWriter, "Invalid command");
            this.closeResource(in);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
            return;
        }
        try {
            CommandHandler commandHandler = SimpleHttpCommandCenter.getHandler(commandName);
            if (commandHandler != null) {
                CommandResponse response = commandHandler.handle(request);
                this.handleResponse(response, printWriter, outputStream);
            } else {
                this.badRequest(printWriter, "Unknown command `" + commandName + '`');
            }
            printWriter.flush();
            long cost = System.currentTimeMillis() - start;
            CommandCenterLog.info((String)("[SimpleHttpCommandCenter] Deal a socket task: " + line + ", address: " + this.socket.getInetAddress() + ", time cost: " + cost + " ms"), (Object[])new Object[0]);
            this.closeResource(in);
            this.closeResource(printWriter);
            this.closeResource(this.socket);
        }
        catch (Throwable e) {
            try {
                CommandCenterLog.warn((String)"[SimpleHttpCommandCenter] CommandCenter error", (Throwable)e);
                try {
                    if (printWriter != null) {
                        String errorMessage = SERVER_ERROR_MESSAGE;
                        if (!this.writtenHead) {
                            this.internalError(printWriter, errorMessage);
                        } else {
                            printWriter.println(errorMessage);
                        }
                        printWriter.flush();
                    }
                }
                catch (Exception e1) {
                    CommandCenterLog.warn((String)"[SimpleHttpCommandCenter] Close server socket failed", (Throwable)e);
                }
                this.closeResource(in);
                this.closeResource(printWriter);
                this.closeResource(this.socket);
            }
            catch (Throwable throwable) {
                this.closeResource(in);
                this.closeResource(printWriter);
                this.closeResource(this.socket);
                throw throwable;
            }
        }
    }

    private void closeResource(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                CommandCenterLog.warn((String)"[SimpleHttpCommandCenter] Close resource failed", (Throwable)e);
            }
        }
    }

    private void handleResponse(CommandResponse response, PrintWriter printWriter, OutputStream rawOutputStream) throws Exception {
        if (response.isSuccess()) {
            if (response.getResult() == null) {
                this.writeOkStatusLine(printWriter);
                return;
            }
            this.writeOkStatusLine(printWriter);
            byte[] buffer = response.getResult().toString().getBytes(SentinelConfig.charset());
            rawOutputStream.write(buffer);
            rawOutputStream.flush();
        } else {
            String msg = SERVER_ERROR_MESSAGE;
            if (response.getException() != null) {
                msg = response.getException().getMessage();
            }
            this.badRequest(printWriter, msg);
        }
    }

    private void badRequest(PrintWriter out, String message) {
        out.print("HTTP/1.1 400 Bad Request\r\nConnection: close\r\n\r\n");
        out.print(message);
        out.flush();
        this.writtenHead = true;
    }

    private void internalError(PrintWriter out, String message) {
        out.print("HTTP/1.1 500 Internal Server Error\r\nConnection: close\r\n\r\n");
        out.print(message);
        out.flush();
        this.writtenHead = true;
    }

    private void writeOkStatusLine(PrintWriter out) {
        out.print("HTTP/1.1 200 OK\r\nConnection: close\r\n\r\n");
        out.flush();
        this.writtenHead = true;
    }

    private CommandRequest parseRequest(String line) {
        CommandRequest request = new CommandRequest();
        if (StringUtil.isBlank((String)line)) {
            return request;
        }
        int start = line.indexOf(47);
        int ask = line.indexOf(63) == -1 ? line.lastIndexOf(32) : line.indexOf(63);
        int space = line.lastIndexOf(32);
        String target = line.substring(start != -1 ? start + 1 : 0, ask != -1 ? ask : line.length());
        request.addMetadata("command-target", target);
        if (ask == -1 || ask == space) {
            return request;
        }
        String parameterStr = line.substring(ask != -1 ? ask + 1 : 0, space != -1 ? space : line.length());
        this.parseParams(parameterStr, request);
        return request;
    }

    private void parseParams(String queryString, CommandRequest request) {
        for (String parameter : queryString.split("&")) {
            String[] keyValue;
            if (StringUtil.isBlank((String)parameter) || (keyValue = parameter.split("=")).length != 2) continue;
            String value = StringUtil.trim((String)keyValue[1]);
            try {
                value = URLDecoder.decode(value, SentinelConfig.charset());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            request.addParam(StringUtil.trim((String)keyValue[0]), value);
        }
    }
}

